/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class SubjectAreaGlossaryHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaGlossaryHandler.class.getName();

    public SubjectAreaGlossaryHandler(OMRSAPIHelper oMRSAPIHelper) {
        super(oMRSAPIHelper);
    }

    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            String suppliedGlossaryName = suppliedGlossary.getName();
            if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createGlossary", "name");
            }
            GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
            EntityDetail glossaryEntityDetail = glossaryMapper.map(suppliedGlossary);
            String entityDetailGuid = this.oMRSAPIHelper.callOMRSAddEntity("createGlossary", userId, glossaryEntityDetail);
            response = this.getGlossaryByGuid(userId, entityDetailGuid);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> getGlossaryByGuid(String userId, String guid) {
        String methodName = "getGlossaryByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryByGuid", (String)guid, (String)"guid");
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "Glossary", "getGlossaryByGuid");
            entityDetail.ifPresent(entity -> {
                GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
                response.addResult((Object)glossaryMapper.map((EntityDetail)entity));
            });
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(String userId, FindRequest findRequest) {
        String methodName = "findGlossary";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundGlossaries = this.findEntities(userId, "Glossary", findRequest, GlossaryMapper.class, "findGlossary");
            if (foundGlossaries == null) {
                return response;
            }
            response.addAllResults(foundGlossaries);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getGlossaryRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getGlossaryRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest);
    }

    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            response = this.getGlossaryByGuid(userId, guid);
            if (response.getHead() != null) {
                Glossary currentGlossary = (Glossary)response.getHead();
                if (isReplace) {
                    this.replaceAttributes(currentGlossary, suppliedGlossary);
                } else {
                    this.updateAttributes(currentGlossary, suppliedGlossary);
                }
                Date termFromTime = suppliedGlossary.getEffectiveFromTime();
                Date termToTime = suppliedGlossary.getEffectiveToTime();
                currentGlossary.setEffectiveFromTime(termFromTime);
                currentGlossary.setEffectiveToTime(termToTime);
                GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
                EntityDetail entityDetail = glossaryMapper.map(currentGlossary);
                String glossaryGuid = entityDetail.getGUID();
                this.oMRSAPIHelper.callOMRSUpdateEntity("updateGlossary", userId, entityDetail);
                response = this.getGlossaryByGuid(userId, glossaryGuid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void replaceAttributes(Glossary currentGlossary, Glossary newGlossary) {
        currentGlossary.setName(newGlossary.getName());
        currentGlossary.setQualifiedName(newGlossary.getQualifiedName());
        currentGlossary.setDescription(newGlossary.getDescription());
        currentGlossary.setUsage(newGlossary.getUsage());
        currentGlossary.setAdditionalProperties(newGlossary.getAdditionalProperties());
    }

    private void updateAttributes(Glossary oldGlossary, Glossary newGlossary) {
        if (newGlossary.getName() != null) {
            oldGlossary.setName(newGlossary.getName());
        }
        if (newGlossary.getQualifiedName() != null) {
            oldGlossary.setQualifiedName(newGlossary.getQualifiedName());
        }
        if (newGlossary.getDescription() != null) {
            oldGlossary.setDescription(newGlossary.getDescription());
        }
        if (newGlossary.getUsage() != null) {
            oldGlossary.setUsage(newGlossary.getUsage());
        }
        if (newGlossary.getAdditionalProperties() != null) {
            oldGlossary.setAdditionalProperties(newGlossary.getAdditionalProperties());
        }
    }

    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        block4: {
            String methodName = "deleteGlossary";
            response = new SubjectAreaOMASAPIResponse();
            try {
                if (isPurge.booleanValue()) {
                    this.oMRSAPIHelper.callOMRSPurgeEntity("deleteGlossary", userId, "Glossary", guid);
                    break block4;
                }
                List<String> relationshipTypeNames = Arrays.asList("TermAnchor", "CategoryAnchor");
                if (this.oMRSAPIHelper.isEmptyContent(relationshipTypeNames, userId, guid, "Glossary", "deleteGlossary")) {
                    this.oMRSAPIHelper.callOMRSDeleteEntity("deleteGlossary", userId, "Glossary", guid);
                    break block4;
                }
                throw new EntityNotDeletedException(SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE.getMessageDefinition(new String[]{guid}), className, "deleteGlossary", guid);
            }
            catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(String userId, String guid) {
        String methodName = "restoreGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreEntity("restoreGlossary", userId, guid);
            response = this.getGlossaryByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

