/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class SubjectAreaTermHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaTermHandler.class.getName();

    public SubjectAreaTermHandler(OMRSAPIHelper oMRSAPIHelper) {
        super(oMRSAPIHelper);
    }

    public SubjectAreaOMASAPIResponse<Term> createTerm(String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        String createdTermGuid = null;
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
            String suppliedTermName = suppliedTerm.getName();
            if (suppliedTermName == null || suppliedTermName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createTerm", "Name", null);
            }
            TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
            EntityDetail termEntityDetail = termMapper.map(suppliedTerm);
            GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
            String glossaryGuid = this.validateGlossarySummaryDuringCreation(userId, "createTerm", suppliedGlossary);
            createdTermGuid = this.oMRSAPIHelper.callOMRSAddEntity("createTerm", userId, termEntityDetail);
            if (createdTermGuid != null) {
                TermAnchor termAnchor = new TermAnchor();
                termAnchor.setGlossaryGuid(glossaryGuid);
                termAnchor.setTermGuid(createdTermGuid);
                TermAnchorMapper termAnchorMapper = this.mappersFactory.get(TermAnchorMapper.class);
                Relationship relationship = termAnchorMapper.map(termAnchor);
                this.oMRSAPIHelper.callOMRSAddRelationship("createTerm", userId, relationship);
                response = this.getTermByGuid(userId, createdTermGuid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            if (createdTermGuid != null) {
                this.deleteTerm(userId, createdTermGuid, false);
                this.deleteTerm(userId, createdTermGuid, true);
            }
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getTermByGuid(String userId, String guid) {
        String methodName = "getTermByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "GlossaryTerm", "getTermByGuid");
            if (entityDetail.isPresent()) {
                TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
                Term term = termMapper.map(entityDetail.get());
                this.setGlossary(userId, term, "getTermByGuid");
                response.addResult((Object)term);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> findTerm(String userId, FindRequest findRequest) {
        SubjectAreaOMASAPIResponse response;
        block4: {
            String methodName = "findTerm";
            response = new SubjectAreaOMASAPIResponse();
            try {
                List foundTerms = this.findEntities(userId, "GlossaryTerm", findRequest, TermMapper.class, "findTerm");
                if (foundTerms != null) {
                    for (Term term : foundTerms) {
                        this.setGlossary(userId, term, "findTerm");
                        response.addResult((Object)term);
                    }
                    break block4;
                }
                return response;
            }
            catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    private void setGlossary(String userId, Term term, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String guid = term.getSystemAttributes().getGUID();
        List<Relationship> relationships = this.oMRSAPIHelper.getRelationshipsByType(userId, guid, "GlossaryTerm", "TermAnchor", methodName);
        if (CollectionUtils.isNotEmpty(relationships)) {
            for (Relationship relationship : relationships) {
                TermAnchorMapper termAnchorMapper = this.mappersFactory.get(TermAnchorMapper.class);
                TermAnchor termAnchor = (TermAnchor)termAnchorMapper.map(relationship);
                GlossarySummary glossarySummary = this.getGlossarySummary(methodName, userId, (Line)termAnchor);
                if (glossarySummary == null) continue;
                term.setGlossary(glossarySummary);
                break;
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Line> getTermRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getTermRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest);
    }

    public SubjectAreaOMASAPIResponse<Term> updateTerm(String userId, String guid, Term suppliedTerm, boolean isReplace) {
        String methodName = "updateTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term, NodeType.Activity});
            response = this.getTermByGuid(userId, guid);
            if (response.getHead() != null) {
                List classifications;
                Term currentTerm = (Term)response.getHead();
                Set<String> currentClassificationNames = this.getCurrentClassificationNames(currentTerm);
                if (isReplace) {
                    this.replaceAttributes(currentTerm, suppliedTerm);
                } else {
                    this.updateAttributes(currentTerm, suppliedTerm);
                }
                Date termFromTime = suppliedTerm.getEffectiveFromTime();
                Date termToTime = suppliedTerm.getEffectiveToTime();
                currentTerm.setEffectiveFromTime(termFromTime);
                currentTerm.setEffectiveToTime(termToTime);
                currentTerm.setGovernanceActions(suppliedTerm.getGovernanceActions());
                TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
                EntityDetail forUpdate = termMapper.map(currentTerm);
                Optional<EntityDetail> updatedEntity = this.oMRSAPIHelper.callOMRSUpdateEntity("updateTerm", userId, forUpdate);
                if (updatedEntity.isPresent() && CollectionUtils.isNotEmpty((Collection)(classifications = forUpdate.getClassifications()))) {
                    for (Classification classification : classifications) {
                        this.oMRSAPIHelper.callOMRSClassifyEntity("updateTerm", userId, guid, classification);
                        currentClassificationNames.remove(classification.getName());
                    }
                    for (String deClassifyName : currentClassificationNames) {
                        this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, deClassifyName);
                    }
                }
                response = this.getTermByGuid(userId, guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private Set<String> getCurrentClassificationNames(Term currentTerm) {
        Set<String> currentClassificationNames = currentTerm.getClassifications().stream().map(x -> x.getClassificationName()).collect(Collectors.toSet());
        GovernanceActions currentActions = currentTerm.getGovernanceActions();
        if (currentActions != null) {
            if (currentActions.getConfidence() != null) {
                currentClassificationNames.add(currentActions.getConfidence().getClassificationName());
            }
            if (currentActions.getConfidentiality() != null) {
                currentClassificationNames.add(currentActions.getConfidentiality().getClassificationName());
            }
            if (currentActions.getRetention() != null) {
                currentClassificationNames.add(currentActions.getRetention().getClassificationName());
            }
            if (currentActions.getCriticality() != null) {
                currentClassificationNames.add(currentActions.getCriticality().getClassificationName());
            }
        }
        return currentClassificationNames;
    }

    private void replaceAttributes(Term currentTerm, Term newTerm) {
        currentTerm.setName(newTerm.getName());
        currentTerm.setQualifiedName(newTerm.getQualifiedName());
        currentTerm.setDescription(newTerm.getDescription());
        currentTerm.setAbbreviation(newTerm.getAbbreviation());
        currentTerm.setExamples(newTerm.getExamples());
        currentTerm.setUsage(newTerm.getUsage());
        currentTerm.setObjectIdentifier(newTerm.isObjectIdentifier());
        currentTerm.setSpineAttribute(newTerm.isSpineAttribute());
        currentTerm.setSpineObject(newTerm.isSpineObject());
        currentTerm.setAdditionalProperties(newTerm.getAdditionalProperties());
        currentTerm.setClassifications(newTerm.getClassifications());
    }

    private void updateAttributes(Term currentTerm, Term newTerm) {
        if (newTerm.getName() != null) {
            currentTerm.setName(newTerm.getName());
        }
        if (newTerm.getQualifiedName() != null) {
            currentTerm.setQualifiedName(newTerm.getQualifiedName());
        }
        if (newTerm.getDescription() != null) {
            currentTerm.setDescription(newTerm.getDescription());
        }
        if (newTerm.getUsage() != null) {
            currentTerm.setUsage(newTerm.getUsage());
        }
        if (newTerm.getAbbreviation() != null) {
            currentTerm.setAbbreviation(newTerm.getAbbreviation());
        }
        if (newTerm.getAdditionalProperties() != null) {
            currentTerm.setAdditionalProperties(newTerm.getAdditionalProperties());
        }
        if (newTerm.getExamples() != null) {
            currentTerm.setExamples(newTerm.getExamples());
        }
        if (newTerm.getClassifications() != null) {
            currentTerm.setClassifications(newTerm.getClassifications());
        }
    }

    public SubjectAreaOMASAPIResponse<Term> deleteTerm(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeEntity("deleteTerm", userId, "GlossaryTerm", guid);
            } else {
                this.oMRSAPIHelper.callOMRSDeleteEntity("deleteTerm", userId, "GlossaryTerm", guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> restoreTerm(String userId, String guid) {
        String methodName = "restoreTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreEntity("restoreTerm", userId, guid);
            response = this.getTermByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

