/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaProjectHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SubjectAreaServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.SUBJECT_AREA_OMAS;
    private OMRSAPIHelper oMRSAPIHelper;
    private SubjectAreaGlossaryHandler glossaryHandler;
    private SubjectAreaProjectHandler projectHandler;
    private SubjectAreaTermHandler termHandler;
    private SubjectAreaCategoryHandler categoryHandler;
    private SubjectAreaRelationshipHandler relationshipHandler;
    private SubjectAreaGraphHandler graphHandler;

    public SubjectAreaServicesInstance(OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler != null) {
            if (this.oMRSAPIHelper == null) {
                this.oMRSAPIHelper = new OMRSAPIHelper(this.serviceName, this.serverName, this.repositoryHandler, this.repositoryHelper);
            }
            this.glossaryHandler = new SubjectAreaGlossaryHandler(this.oMRSAPIHelper);
            this.termHandler = new SubjectAreaTermHandler(this.oMRSAPIHelper);
            this.categoryHandler = new SubjectAreaCategoryHandler(this.oMRSAPIHelper);
            this.projectHandler = new SubjectAreaProjectHandler(this.oMRSAPIHelper);
            this.graphHandler = new SubjectAreaGraphHandler(this.oMRSAPIHelper);
            this.relationshipHandler = new SubjectAreaRelationshipHandler(this.oMRSAPIHelper);
        }
    }

    public SubjectAreaGlossaryHandler getGlossaryHandler() {
        return this.glossaryHandler;
    }

    public SubjectAreaProjectHandler getProjectHandler() {
        return this.projectHandler;
    }

    public SubjectAreaTermHandler getTermHandler() {
        return this.termHandler;
    }

    public SubjectAreaCategoryHandler getCategoryHandler() {
        return this.categoryHandler;
    }

    public SubjectAreaRelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }

    public SubjectAreaGraphHandler getGraphHandler() {
        return this.graphHandler;
    }
}

