/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;

public class ClassificationGroupByOperation {
    Map<String, Classification> existingMap = new HashMap<String, Classification>();
    Map<String, Classification> requestedMap = new HashMap<String, Classification>();
    List<Classification> add = new ArrayList<Classification>();
    List<String> remove = new ArrayList<String>();
    List<Classification> update = new ArrayList<Classification>();

    public ClassificationGroupByOperation(Set<String> relevantClassificationNames, Set<Classification> existing, Set<Classification> requested) {
        Set existingNames = null;
        if (!existing.isEmpty()) {
            existingNames = existing.stream().map(Classification::getClassificationName).collect(Collectors.toSet());
            this.existingMap = existing.stream().collect(Collectors.toMap(Classification::getClassificationName, Function.identity()));
        }
        Set requestedNames = null;
        if (!requested.isEmpty()) {
            requestedNames = requested.stream().map(Classification::getClassificationName).collect(Collectors.toSet());
            this.requestedMap = requested.stream().collect(Collectors.toMap(Classification::getClassificationName, Function.identity()));
        }
        if (existingNames == null && requestedNames != null) {
            this.add = new ArrayList<Classification>(requested);
        }
        if (requestedNames == null && existingNames != null) {
            HashSet<String> intersection = new HashSet<String>(relevantClassificationNames);
            intersection.retainAll(existingNames);
            this.remove = new ArrayList<String>(intersection);
        }
        if (existingNames != null && requestedNames != null) {
            for (String existingName : existingNames) {
                if (requestedNames.contains(existingName)) {
                    this.update.add(this.requestedMap.get(existingName));
                    continue;
                }
                if (!relevantClassificationNames.contains(existingName)) continue;
                this.remove.add(existingName);
            }
            for (String requestedName : requestedNames) {
                if (existingNames.contains(requestedName)) continue;
                this.add.add(this.requestedMap.get(requestedName));
            }
        }
    }

    public List<Classification> getAddClassifications() {
        return this.add;
    }

    public List<String> getRemoveClassifications() {
        return this.remove;
    }

    public List<Classification> getUpdateClassifications() {
        return this.update;
    }
}

