/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.ProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectHandler
extends SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaProjectHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);

    public SubjectAreaProjectHandler(OMRSAPIHelper oMRSAPIHelper) {
        super(oMRSAPIHelper);
    }

    public SubjectAreaOMASAPIResponse<Project> createProject(String userId, Project suppliedProject) {
        String methodName = "createProject";
        SubjectAreaOMASAPIResponse<Project> response = new SubjectAreaOMASAPIResponse<Project>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
            String suppliedProjectName = suppliedProject.getName();
            if (suppliedProjectName == null || suppliedProjectName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_PROJECT_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createProject", "Name", null);
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedProject);
            ProjectMapper projectMapper = this.mappersFactory.get(ProjectMapper.class);
            EntityDetail projectEntityDetail = projectMapper.map(suppliedProject);
            String entityDetailGuid = this.oMRSAPIHelper.callOMRSAddEntity("createProject", userId, projectEntityDetail);
            response = this.getProjectByGuid(userId, entityDetailGuid);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> getProjectByGuid(String userId, String guid) {
        String methodName = "getProjectByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "Project", "getProjectByGuid");
            if (entityDetail.isPresent()) {
                ProjectMapper projectMapper = this.mappersFactory.get(ProjectMapper.class);
                Project project = projectMapper.map(entityDetail.get());
                response.addResult((Object)project);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> findProject(String userId, FindRequest findRequest) {
        String methodName = "findProject";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundGlossaries = this.findEntities(userId, "Project", findRequest, ProjectMapper.class, "findProject");
            if (foundGlossaries == null) {
                return response;
            }
            response.addAllResults(foundGlossaries);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getProjectRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getProjectRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest);
    }

    public SubjectAreaOMASAPIResponse<Project> updateProject(String userId, String guid, Project suppliedProject, boolean isReplace) {
        String methodName = "updateProject";
        SubjectAreaOMASAPIResponse<Project> response = new SubjectAreaOMASAPIResponse<Project>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
            response = this.getProjectByGuid(userId, guid);
            if (response.head().isPresent()) {
                Project updateProject = (Project)response.head().get();
                if (isReplace) {
                    this.replaceAttributes(updateProject, suppliedProject);
                } else {
                    this.updateAttributes(updateProject, suppliedProject);
                }
                Date termFromTime = suppliedProject.getEffectiveFromTime();
                Date termToTime = suppliedProject.getEffectiveToTime();
                updateProject.setEffectiveFromTime(termFromTime);
                updateProject.setEffectiveToTime(termToTime);
                ProjectMapper projectMapper = this.mappersFactory.get(ProjectMapper.class);
                EntityDetail entityDetail = projectMapper.map(updateProject);
                String projectGuid = entityDetail.getGUID();
                this.oMRSAPIHelper.callOMRSUpdateEntity("updateProject", userId, entityDetail);
                response = this.getProjectByGuid(userId, projectGuid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    private void replaceAttributes(Project currentProject, Project newProject) {
        currentProject.setName(newProject.getName());
        currentProject.setQualifiedName(newProject.getQualifiedName());
        currentProject.setDescription(newProject.getDescription());
        currentProject.setStartDate(newProject.getStartDate());
        currentProject.setPlannedEndDate(newProject.getPlannedEndDate());
        currentProject.setStatus(newProject.getStatus());
        currentProject.setAdditionalProperties(newProject.getAdditionalProperties());
    }

    private void updateAttributes(Project currentProject, Project newProject) {
        if (newProject.getName() != null) {
            currentProject.setName(newProject.getName());
        }
        if (newProject.getQualifiedName() != null) {
            currentProject.setQualifiedName(newProject.getQualifiedName());
        }
        if (newProject.getDescription() != null) {
            currentProject.setDescription(newProject.getDescription());
        }
        if (newProject.getStartDate() != null) {
            currentProject.setStartDate(newProject.getStartDate());
        }
        if (newProject.getPlannedEndDate() != null) {
            currentProject.setPlannedEndDate(newProject.getPlannedEndDate());
        }
        if (newProject.getStatus() != null) {
            currentProject.setStatus(newProject.getStatus());
        }
        if (newProject.getAdditionalProperties() != null) {
            currentProject.setAdditionalProperties(newProject.getAdditionalProperties());
        }
    }

    public SubjectAreaOMASAPIResponse<Project> deleteProject(String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        block4: {
            String methodName = "deleteProject";
            response = new SubjectAreaOMASAPIResponse();
            try {
                if (isPurge.booleanValue()) {
                    this.oMRSAPIHelper.callOMRSPurgeEntity("deleteProject", userId, "Project", guid);
                    break block4;
                }
                List<String> relationshipTypeNames = Arrays.asList("TermAnchor", "CategoryAnchor");
                if (this.oMRSAPIHelper.isEmptyContent(relationshipTypeNames, userId, guid, "Project", "deleteProject")) {
                    this.oMRSAPIHelper.callOMRSDeleteEntity("deleteProject", userId, "Project", guid);
                    break block4;
                }
                throw new EntityNotDeletedException(SubjectAreaErrorCode.PROJECT_CONTENT_PREVENTED_DELETE.getMessageDefinition(new String[]{guid}), className, "deleteProject", guid);
            }
            catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> restoreProject(String userId, String guid) {
        String methodName = "restoreProject";
        SubjectAreaOMASAPIResponse<Project> response = new SubjectAreaOMASAPIResponse<Project>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreEntity("restoreProject", userId, guid);
            response = this.getProjectByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getProjectTerms(String userId, String guid) {
        String methodName = "getProjectTerms";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List<EntityDetail> entityDetails = this.oMRSAPIHelper.callGetEntitiesForRelationshipEnd1("getProjectTerms", userId, guid, "Project", "ProjectScope");
            List terms = this.convertOmrsToOmas(entityDetails, TermMapper.class);
            response.addAllResults(terms);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

