/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.CanonicalVocabularyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ConfidenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ConfidentialityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.CriticalityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.GlossaryProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ObjectIdentifierMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.RetentionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.SpineAttributeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.SpineObjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.TaxonomyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassificationFactory.class);
    private static final String className = ClassificationFactory.class.getName();
    protected final OMRSAPIHelper omrsapiHelper;
    private OMRSRepositoryHelper repositoryHelper;

    public ClassificationFactory(OMRSAPIHelper omrsapiHelper) {
        this.omrsapiHelper = omrsapiHelper;
        this.repositoryHelper = omrsapiHelper.getOMRSRepositoryHelper();
    }

    public org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification getOMASClassification(String name, Classification omrsClassification) {
        String serviceName = this.omrsapiHelper.getServiceName();
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineAttribute")) {
            return new SpineAttributeMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "CanonicalVocabulary")) {
            return new CanonicalVocabularyMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidence")) {
            return new ConfidenceMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Criticality")) {
            return new CriticalityMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "GlossaryProject")) {
            return new GlossaryProjectMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineObject")) {
            return new SpineObjectMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Taxonomy")) {
            return new TaxonomyMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Retention")) {
            return new RetentionMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SubjectArea")) {
            return new SubjectAreaMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "ObjectIdentifier")) {
            return new ObjectIdentifierMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidentiality")) {
            return new ConfidentialityMapper(this.omrsapiHelper).mapOmrsToBean(omrsClassification);
        }
        return null;
    }

    public Classification getOMRSClassification(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        String name = omasClassification.getClassificationName();
        String serviceName = this.omrsapiHelper.getServiceName();
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineAttribute")) {
            return new SpineAttributeMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "CanonicalVocabulary")) {
            return new CanonicalVocabularyMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidence")) {
            return new ConfidenceMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Criticality")) {
            return new CriticalityMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "GlossaryProject")) {
            return new GlossaryProjectMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineObject")) {
            return new SpineObjectMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Taxonomy")) {
            return new TaxonomyMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Retention")) {
            return new RetentionMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SubjectArea")) {
            return new SubjectAreaMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "ObjectIdentifier")) {
            return new ObjectIdentifierMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidentiality")) {
            return new ConfidentialityMapper(this.omrsapiHelper).mapBeanToOmrs(omasClassification);
        }
        return null;
    }
}

