/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubjectAreaMapper
public class CategoryMapper
extends EntityDetailMapper<Category> {
    private static final Logger log = LoggerFactory.getLogger(CategoryMapper.class);
    private static final String className = CategoryMapper.class.getName();
    public static final String GLOSSARY_CATEGORY = "GlossaryCategory";

    public CategoryMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    public Category map(EntityDetail entityDetail) {
        Set classificationNames;
        Category category = new Category();
        if (entityDetail.getClassifications() != null && (classificationNames = entityDetail.getClassifications().stream().map((? super T x) -> x.getName()).collect(Collectors.toSet())).contains("SubjectArea")) {
            category = new SubjectAreaDefinition();
        }
        this.mapEntityDetailToNode(category, entityDetail);
        return category;
    }

    @Override
    public EntityDetail map(Category node) {
        return super.toEntityDetail(node);
    }

    @Override
    protected void mapNodeToInstanceProperties(Category node, InstanceProperties instanceProperties) {
        if (node.getName() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getName(), "displayName");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Category category, Classification omasClassification) {
        boolean handled = false;
        String classificationName = omasClassification.getClassificationName();
        NodeType nodeType = NodeType.Category;
        if (this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), "SubjectArea", classificationName)) {
            nodeType = NodeType.SubjectAreaDefinition;
            handled = true;
        }
        category.setNodeType(nodeType);
        return handled;
    }

    @Override
    protected List<Classification> getInlinedClassifications(Category node) {
        ArrayList<Classification> inlinedClassifications = new ArrayList<Classification>();
        if (node.getNodeType() == NodeType.SubjectAreaDefinition) {
            SubjectArea subjectArea = new SubjectArea();
            subjectArea.setName(node.getName());
            inlinedClassifications.add((Classification)subjectArea);
        }
        return inlinedClassifications;
    }

    @Override
    public String getTypeName() {
        return GLOSSARY_CATEGORY;
    }
}

