/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(LineTypeMapper.class);
    private static final String className = LineTypeMapper.class.getName();

    public static String mapLineTypeToRelationshipTypeGuid(LineType lineType) {
        String relationshipTypeName = lineType.name();
        if (lineType.equals((Object)LineType.HasA)) {
            relationshipTypeName = "TermHASARelationship";
        } else if (lineType.equals((Object)LineType.IsA)) {
            relationshipTypeName = "ISARelationship";
        } else if (lineType.equals((Object)LineType.IsATypeOf)) {
            relationshipTypeName = "TermISATypeOFRelationship";
        } else if (lineType.equals((Object)LineType.TypedBy)) {
            relationshipTypeName = "TermTYPEDBYRelationship";
        }
        return OpenMetadataTypesArchiveAccessor.getInstance().getRelationshipDefByName(relationshipTypeName).getGUID();
    }
}

