/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class LineMapper<L extends Line>
implements ILineMapper<L> {
    protected final OMRSAPIHelper omrsapiHelper;
    protected final OMRSRepositoryHelper repositoryHelper;

    public LineMapper(OMRSAPIHelper omrsapiHelper) {
        this.omrsapiHelper = omrsapiHelper;
        this.repositoryHelper = omrsapiHelper.getOMRSRepositoryHelper();
    }

    @Override
    public L map(Relationship relationship) {
        InstanceProperties relationshipProperties;
        String guid2;
        EntityProxy proxy2;
        String guid1;
        L line = this.getLineInstance();
        line.setSystemAttributes(SubjectAreaUtils.createSystemAttributes((InstanceHeader)relationship));
        EntityProxy proxy1 = relationship.getEntityOneProxy();
        if (proxy1 != null && (guid1 = proxy1.getGUID()) != null) {
            line.getEnd1().setNodeGuid(guid1);
        }
        if ((proxy2 = relationship.getEntityTwoProxy()) != null && (guid2 = proxy2.getGUID()) != null) {
            line.getEnd2().setNodeGuid(guid2);
        }
        if ((relationshipProperties = relationship.getProperties()) != null) {
            this.mapLineEffectivityToInstanceProperties(line, relationshipProperties);
            Iterator omrsPropertyIterator = relationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String propertyName = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = relationshipProperties.getPropertyValue(propertyName);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (this.mapPrimitiveToLine(line, propertyName, actualValue)) break;
                        if (null == line.getAdditionalProperties()) {
                            line.setAdditionalProperties(new HashMap());
                        }
                        line.getAdditionalProperties().put(propertyName, actualValue.toString());
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        if (this.mapEnumToLine(line, propertyName, enumPropertyValue)) break;
                        if (null == line.getAdditionalProperties()) {
                            line.setAdditionalProperties(new HashMap());
                        }
                        line.getAdditionalProperties().put(propertyName, enumPropertyValue.valueAsString());
                        break;
                    }
                    case MAP: {
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                        if (this.mapMapToLine(line, propertyName, instancePropertyForMap)) break;
                        if (null == line.getAdditionalProperties()) {
                            line.setAdditionalProperties(new HashMap());
                        }
                        line.getAdditionalProperties().put(propertyName, mapPropertyValue.valueAsString());
                        break;
                    }
                }
            }
        }
        return line;
    }

    protected void mapInstancePropertiesToLine(L line, InstanceProperties instanceProperties) {
    }

    private void mapLineEffectivityToInstanceProperties(L line, InstanceProperties instanceProperties) {
        instanceProperties.setEffectiveFromTime(line.getEffectiveFromTime());
        instanceProperties.setEffectiveToTime(line.getEffectiveToTime());
    }

    @Override
    public Relationship map(L line) {
        Relationship relationship = new Relationship();
        InstanceProperties instanceProperties = new InstanceProperties();
        relationship.setProperties(instanceProperties);
        this.mapLineToInstanceProperties(line, instanceProperties);
        String proxy1Guid = line.getEnd1().getNodeGuid();
        String proxy2Guid = line.getEnd2().getNodeGuid();
        EntityProxy proxy1 = new EntityProxy();
        proxy1.setGUID(proxy1Guid);
        relationship.setEntityOneProxy(proxy1);
        EntityProxy proxy2 = new EntityProxy();
        proxy2.setGUID(proxy2Guid);
        relationship.setEntityTwoProxy(proxy2);
        String typeName = this.getTypeName();
        TypeDef typedef = this.omrsapiHelper.getOMRSRepositoryHelper().getTypeDefByName(this.omrsapiHelper.getServiceName(), typeName);
        InstanceType type = new InstanceType();
        type.setTypeDefName(typedef.getName());
        type.setTypeDefGUID(typedef.getGUID());
        relationship.setType(type);
        if (line.getSystemAttributes() != null) {
            SubjectAreaUtils.populateSystemAttributesForInstanceAuditHeader(line.getSystemAttributes(), (InstanceAuditHeader)relationship);
            relationship.setGUID(line.getSystemAttributes().getGUID());
        }
        return relationship;
    }

    @Override
    public abstract String getTypeName();

    abstract L getLineInstance();

    @Override
    public String getTypeDefGuid() {
        return this.omrsapiHelper.getTypeDefGUID(this.getTypeName());
    }

    protected boolean mapPrimitiveToLine(L line, String propertyName, Object value) {
        return false;
    }

    protected boolean mapEnumToLine(L line, String propertyName, EnumPropertyValue enumPropertyValue) {
        return false;
    }

    protected boolean mapMapToLine(L line, String propertyName, InstanceProperties instancePropertyForMap) {
        return false;
    }

    protected void mapLineToInstanceProperties(L line, InstanceProperties instanceProperties) {
    }
}

