/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaTermRESTServices.class);
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();
    private static final String className = SubjectAreaTermRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Term> createTerm(String serverName, String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, "createTerm");
            response = handler.createTerm(userId, suppliedTerm);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getTermByGuid(String serverName, String userId, String guid) {
        String methodName = "getTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermByGuid,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, "getTermByGuid");
            response = handler.getTermByGuid(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getTermRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getTermRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Line> response = new SubjectAreaOMASAPIResponse<Line>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, methodName);
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset.intValue());
            findRequest.setPageSize(pageSize.intValue());
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.getTermRelationships(userId, guid, findRequest);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> findTerm(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findTerm,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, "findTerm");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset.intValue());
            findRequest.setPageSize(pageSize.intValue());
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.findTerm(userId, findRequest);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findTerm,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> updateTerm(String serverName, String userId, String guid, Term suppliedTerm, boolean isReplace) {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, "updateTerm");
            response = handler.updateTerm(userId, guid, suppliedTerm, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> deleteTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, "deleteTerm");
            response = handler.deleteTerm(userId, guid, isPurge);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> restoreTerm(String serverName, String userId, String guid) {
        String methodName = "restoreTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTerm,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaTermHandler handler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, "restoreTerm");
            response = handler.restoreTerm(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTerm,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

