/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final String className = SubjectAreaTermHandler.class.getName();
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryHandler.class);
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    public SubjectAreaOMASAPIResponse<Category> createCategory(String serverName, String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategory,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler categoryHandler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "createCategory");
            response = categoryHandler.createCategory(userId, suppliedCategory);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategory(String serverName, String userId, String guid) {
        String methodName = "getCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryByGuid,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "getCategoryByGuid");
            response = handler.getCategoryByGuid(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryByGuid,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> findCategory(String serverName, String userId, String searchCriteria, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findCategory,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "findCategory");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.findCategory(userId, findRequest);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getCategoryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryRelationships,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Line> response = new SubjectAreaOMASAPIResponse<Line>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "getCategoryRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.getCategoryRelationships(userId, guid, findRequest);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryRelationships,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> updateCategory(String serverName, String userId, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "updateCategory");
            response = handler.updateCategory(userId, guid, suppliedCategory, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> deleteCategory(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "deleteCategory");
            response = handler.deleteCategory(userId, guid, isPurge);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "restoreCategory");
            response = handler.restoreCategory(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getCategorizedTerms(String serverName, String userId, String guid, Integer startingFrom, Integer pageSize) {
        String methodName = "getCategorizedTerms";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategorizedTerms,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "getCategorizedTerms");
            response = handler.getCategorizedTerms(userId, guid, instanceHandler.getSubjectAreaTermHandler(userId, serverName, "getCategorizedTerms"), startingFrom, pageSize);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategorizedTerms,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategoryChildren(String serverName, String userId, String guid, Integer startingFrom, Integer pageSize) {
        String methodName = "getCategoryChildren";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryChildren,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "getCategoryChildren");
            response = handler.getCategoryChildren(userId, guid, startingFrom, pageSize);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryChildren,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

