/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.OmasObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.Mapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.MappersFactory;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public abstract class SubjectAreaHandler {
    private static final String className = SubjectAreaHandler.class.getName();
    protected static final String GLOSSARY_TYPE_NAME = "Glossary";
    protected static final String CATEGORY_TYPE_NAME = "GlossaryCategory";
    protected static final String TERM_TYPE_NAME = "GlossaryTerm";
    protected static final String PROJECT_TYPE_NAME = "Project";
    protected static final String TERM_ANCHOR_RELATIONSHIP_NAME = "TermAnchor";
    protected static final String TERM_CATEGORIZATION_RELATIONSHIP_NAME = "TermCategorization";
    protected static final String PROJECT_SCOPE_RELATIONSHIP_NAME = "ProjectScope";
    protected static final String CATEGORY_ANCHOR_RELATIONSHIP_NAME = "CategoryAnchor";
    protected static final String CATEGORY_HIERARCHY_LINK_RELATIONSHIP_NAME = "CategoryHierarchyLink";
    protected final MappersFactory mappersFactory;
    protected final OMRSAPIHelper oMRSAPIHelper;
    protected final int maxPageSize;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public SubjectAreaHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        this.oMRSAPIHelper = oMRSAPIHelper;
        this.mappersFactory = new MappersFactory(oMRSAPIHelper);
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(this.maxPageSize);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    GlossarySummary getGlossarySummary(String restAPIName, String userId, Line line) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, SubjectAreaCheckedException {
        String guid = SubjectAreaUtils.getGlossaryGuidFromAnchor(line);
        Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, GLOSSARY_TYPE_NAME, restAPIName);
        if (entityDetail.isPresent()) {
            GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
            Glossary glossary = glossaryMapper.map(entityDetail.get());
            return SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary, line);
        }
        return null;
    }

    CategorySummary getCategorySummary(String restAPIName, String userId, Line line) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, SubjectAreaCheckedException {
        String categoryGuid = line.getEnd1().getNodeGuid();
        Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, categoryGuid, CATEGORY_TYPE_NAME, restAPIName);
        if (entityDetail.isPresent()) {
            CategoryMapper CategoryMapper2 = this.mappersFactory.get(CategoryMapper.class);
            Category category = CategoryMapper2.map(entityDetail.get());
            return SubjectAreaUtils.extractCategorySummaryFromCategory(category, line);
        }
        return null;
    }

    protected <T extends Node> List<T> findEntities(String userId, String typeEntityName, FindRequest findRequest, Class<? extends INodeMapper<T>> mapperClass, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        List<EntityDetail> entityDetails = null;
        List<T> foundEntities = null;
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
        }
        this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
        entityDetails = findRequest.getSearchCriteria() == null ? this.oMRSAPIHelper.getEntitiesByType(methodName, userId, typeEntityName, findRequest) : this.oMRSAPIHelper.findEntitiesByPropertyValue(methodName, userId, typeEntityName, findRequest);
        if (entityDetails != null) {
            foundEntities = this.convertOmrsToOmas(entityDetails, mapperClass);
        }
        return foundEntities;
    }

    public <T extends Node> SubjectAreaOMASAPIResponse<T> getRelatedNodesForEnd1(String methodName, String userId, String guid, String relationshipTypeName, Class<? extends INodeMapper<T>> mapperClass, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            if (pageSize == null) {
                pageSize = this.maxPageSize;
            }
            this.invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), methodName);
            INodeMapper<T> mapper = this.mappersFactory.get(mapperClass);
            List<EntityDetail> entityDetails = this.oMRSAPIHelper.callGetEntitiesForRelationshipEnd1(methodName, userId, guid, mapper.getTypeName(), relationshipTypeName, startingFrom, pageSize);
            if (entityDetails != null) {
                for (EntityDetail entityDetail : entityDetails) {
                    response.addResult(mapper.map(entityDetail));
                }
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <T extends Node> SubjectAreaOMASAPIResponse<T> getRelatedNodesForEnd2(String methodName, String userId, String guid, String relationshipTypeName, Class<? extends INodeMapper<T>> mapperClass, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            if (pageSize == null) {
                pageSize = this.maxPageSize;
            }
            this.invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), methodName);
            INodeMapper<T> mapper = this.mappersFactory.get(mapperClass);
            List<EntityDetail> entityDetails = this.oMRSAPIHelper.callGetEntitiesForRelationshipEnd2(methodName, userId, guid, mapper.getTypeName(), relationshipTypeName, startingFrom, pageSize);
            if (entityDetails != null) {
                for (EntityDetail entityDetail : entityDetails) {
                    response.addResult(mapper.map(entityDetail));
                }
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getAllRelationshipsForEntity(String methodName, String userId, String guid, FindRequest findRequest) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            if (findRequest.getPageSize() == null) {
                findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
            }
            this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
            response.addAllResults(this.getAllLineForEntity(methodName, userId, guid, findRequest));
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public List<Line> getAllLineForEntity(String restAPIName, String userId, String entityGuid, FindRequest findRequest) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
        }
        this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), restAPIName);
        List<Relationship> relationships = this.oMRSAPIHelper.getAllRelationshipsForEntity(restAPIName, userId, entityGuid, findRequest);
        return this.getLinesFromRelationships(relationships);
    }

    public List<Line> getLinesFromRelationships(Collection<Relationship> relationships) {
        return this.convertOmrsToOmas(relationships, ILineMapper.class);
    }

    public List<Node> getNodesFromEntityDetails(Collection<EntityDetail> entityDetails) {
        return this.convertOmrsToOmas(entityDetails, INodeMapper.class);
    }

    public <R extends InstanceHeader, T extends OmasObject> List<T> convertOmrsToOmas(Collection<R> list, Class<? extends Mapper> mapperInterface) {
        ArrayList result = new ArrayList();
        if (list != null) {
            HashMap<String, Mapper> cache = new HashMap<String, Mapper>();
            for (InstanceHeader entityDetail : list) {
                String typeDefName = entityDetail.getType().getTypeDefName();
                if (cache.containsKey(typeDefName)) {
                    Mapper mapper = (Mapper)cache.get(typeDefName);
                    result.add(mapper.map(entityDetail));
                    continue;
                }
                Set<Class<?>> allMapperClasses = this.mappersFactory.getAllMapperClasses();
                for (Class<?> mapperClass : allMapperClasses) {
                    Mapper mapper;
                    if (!mapperInterface.isAssignableFrom(mapperClass) || !(mapper = mapperInterface.cast(this.mappersFactory.get(mapperClass))).getTypeName().equals(typeDefName)) continue;
                    cache.put(typeDefName, mapper);
                    result.add(mapper.map(entityDetail));
                }
            }
        }
        return result;
    }

    protected String validateGlossarySummaryDuringCreation(String userId, String methodName, GlossarySummary suppliedGlossary) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, SubjectAreaCheckedException {
        if (suppliedGlossary != null) {
            String guid = suppliedGlossary.getGuid();
            String relationshipGuid = suppliedGlossary.getRelationshipguid();
            if (relationshipGuid != null) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP.getMessageDefinition();
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
            }
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, GLOSSARY_TYPE_NAME, methodName);
            if (entityDetail.isPresent()) {
                return entityDetail.get().getGUID();
            }
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition();
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition();
        throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
    }

    protected void setUniqueQualifiedNameIfBlank(Node node) {
        String qualifiedName = node.getQualifiedName();
        if (qualifiedName == null || qualifiedName.trim().equals("")) {
            node.setQualifiedName(node.getName() + "@" + UUID.randomUUID().toString());
        }
    }
}

