/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class SubjectAreaTermHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaTermHandler.class.getName();
    private final TermAnchorMapper termAnchorMapper;
    private final TermCategorizationMapper termCategorizationMapper;
    private final CategoryMapper categoryMapper;

    public SubjectAreaTermHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        super(oMRSAPIHelper, maxPageSize);
        this.termAnchorMapper = this.mappersFactory.get(TermAnchorMapper.class);
        this.termCategorizationMapper = this.mappersFactory.get(TermCategorizationMapper.class);
        this.categoryMapper = this.mappersFactory.get(CategoryMapper.class);
    }

    public SubjectAreaOMASAPIResponse<Term> createTerm(String userId, Term suppliedTerm) {
        SubjectAreaOMASAPIResponse<Term> response;
        block5: {
            String methodName = "createTerm";
            response = new SubjectAreaOMASAPIResponse<Term>();
            String createdTermGuid = null;
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
                String suppliedTermName = suppliedTerm.getName();
                if (suppliedTermName == null || suppliedTermName.equals("")) {
                    ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME.getMessageDefinition();
                    throw new InvalidParameterException(messageDefinition, className, "createTerm", "Name", null);
                }
                this.setUniqueQualifiedNameIfBlank((Node)suppliedTerm);
                TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
                EntityDetail termEntityDetail = termMapper.map(suppliedTerm);
                GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
                List suppliedCategorysummaries = suppliedTerm.getCategories();
                String glossaryGuid = this.validateGlossarySummaryDuringCreation(userId, "createTerm", suppliedGlossary);
                this.validateCategoriesDuringCreation(userId, "createTerm", suppliedCategorysummaries);
                createdTermGuid = this.oMRSAPIHelper.callOMRSAddEntity("createTerm", userId, termEntityDetail);
                if (createdTermGuid == null) break block5;
                TermAnchor termAnchor = new TermAnchor();
                termAnchor.getEnd1().setNodeGuid(glossaryGuid);
                termAnchor.getEnd2().setNodeGuid(createdTermGuid);
                Relationship relationship = this.termAnchorMapper.map(termAnchor);
                this.oMRSAPIHelper.callOMRSAddRelationship("createTerm", userId, relationship);
                response = this.getTermByGuid(userId, createdTermGuid);
                if (response.getRelatedHTTPCode() != 200 || suppliedCategorysummaries == null || suppliedCategorysummaries.size() <= 0) break block5;
                for (CategorySummary categorySummary : suppliedCategorysummaries) {
                    Categorization categorization = new Categorization();
                    categorization.getEnd1().setNodeGuid(categorySummary.getGuid());
                    categorization.getEnd2().setNodeGuid(createdTermGuid);
                    relationship = this.termCategorizationMapper.map(categorization);
                    this.oMRSAPIHelper.callOMRSAddRelationship("createTerm", userId, relationship);
                    response = this.getTermByGuid(userId, createdTermGuid);
                    if (response.getRelatedHTTPCode() == 200) continue;
                    break;
                }
            }
            catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                if (createdTermGuid != null) {
                    this.deleteTerm(userId, createdTermGuid, false);
                    this.deleteTerm(userId, createdTermGuid, true);
                }
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    protected void validateCategoriesDuringCreation(String userId, String methodName, List<CategorySummary> suppliedCategories) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        if (suppliedCategories != null) {
            for (CategorySummary categorySummary : suppliedCategories) {
                String guid = categorySummary.getGuid();
                Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "GlossaryCategory", methodName);
                if (entityDetail.isPresent()) continue;
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.TERM_CREATE_WITH_BAD_CATEGORIES.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, methodName, "categories", null);
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Term> getTermByGuid(String userId, String guid) {
        String methodName = "getTermByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "GlossaryTerm", "getTermByGuid");
            if (entityDetail.isPresent()) {
                TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
                Term term = termMapper.map(entityDetail.get());
                this.setSummaryObjects(userId, term, "getTermByGuid");
                response.addResult((Object)term);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> findTerm(String userId, FindRequest findRequest) {
        SubjectAreaOMASAPIResponse response;
        block4: {
            String methodName = "findTerm";
            response = new SubjectAreaOMASAPIResponse();
            try {
                List foundTerms = this.findEntities(userId, "GlossaryTerm", findRequest, TermMapper.class, "findTerm");
                if (foundTerms != null) {
                    for (Term term : foundTerms) {
                        this.setSummaryObjects(userId, term, "findTerm");
                        response.addResult((Object)term);
                    }
                    break block4;
                }
                return response;
            }
            catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    private void setSummaryObjects(String userId, Term term, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        List<Relationship> termCategorizationRelationships;
        String guid = term.getSystemAttributes().getGUID();
        List<Relationship> termAnchorRelationships = this.oMRSAPIHelper.getRelationshipsByType(userId, guid, "GlossaryTerm", "TermAnchor", methodName);
        if (CollectionUtils.isNotEmpty(termAnchorRelationships)) {
            for (Relationship relationship : termAnchorRelationships) {
                TermAnchor termAnchor = (TermAnchor)this.termAnchorMapper.map(relationship);
                GlossarySummary glossarySummary = this.getGlossarySummary(methodName, userId, (Line)termAnchor);
                if (glossarySummary == null) continue;
                term.setGlossary(glossarySummary);
            }
        }
        if (CollectionUtils.isNotEmpty(termCategorizationRelationships = this.oMRSAPIHelper.getRelationshipsByType(userId, guid, "GlossaryTerm", "TermCategorization", methodName))) {
            ArrayList<CategorySummary> categorySummaryList = new ArrayList<CategorySummary>();
            for (Relationship relationship : termCategorizationRelationships) {
                CategorySummary categorySummary;
                Categorization categorization = (Categorization)this.termCategorizationMapper.map(relationship);
                if (categorization == null || (categorySummary = this.getCategorySummary(methodName, userId, (Line)categorization)) == null) continue;
                categorySummaryList.add(categorySummary);
            }
            if (categorySummaryList.size() > 0) {
                term.setCategories(categorySummaryList);
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Line> getTermRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getTermRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest);
    }

    public SubjectAreaOMASAPIResponse<Term> updateTerm(String userId, String guid, Term suppliedTerm, boolean isReplace) {
        String methodName = "updateTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term, NodeType.Activity});
            response = this.getTermByGuid(userId, guid);
            if (response.head().isPresent()) {
                Term currentTerm = (Term)response.head().get();
                Set<String> currentClassificationNames = this.getCurrentClassificationNames(currentTerm);
                if (isReplace) {
                    this.replaceAttributes(currentTerm, suppliedTerm);
                } else {
                    this.updateAttributes(currentTerm, suppliedTerm);
                }
                Date termFromTime = suppliedTerm.getEffectiveFromTime();
                Date termToTime = suppliedTerm.getEffectiveToTime();
                currentTerm.setEffectiveFromTime(termFromTime);
                currentTerm.setEffectiveToTime(termToTime);
                currentTerm.setGovernanceActions(suppliedTerm.getGovernanceActions());
                TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
                EntityDetail forUpdate = termMapper.map(currentTerm);
                Optional<EntityDetail> updatedEntity = this.oMRSAPIHelper.callOMRSUpdateEntity("updateTerm", userId, forUpdate);
                if (updatedEntity.isPresent()) {
                    List suppliedCategories;
                    List classifications = forUpdate.getClassifications();
                    if (CollectionUtils.isNotEmpty((Collection)classifications)) {
                        for (Classification classification : classifications) {
                            this.oMRSAPIHelper.callOMRSClassifyEntity("updateTerm", userId, guid, classification);
                            currentClassificationNames.remove(classification.getName());
                        }
                        for (String deClassifyName : currentClassificationNames) {
                            this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, deClassifyName);
                        }
                    }
                    if ((suppliedCategories = suppliedTerm.getCategories()) != null || isReplace) {
                        this.replaceCategories(userId, guid, suppliedTerm, "updateTerm");
                    }
                }
                response = this.getTermByGuid(userId, guid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void replaceCategories(String userId, String guid, Term suppliedTerm, String methodName) throws UserNotAuthorizedException, PropertyServerException, SubjectAreaCheckedException, InvalidParameterException {
        List suppliedCategories;
        HashSet<String> deleteCategorizationGuidSet = new HashSet<String>();
        SubjectAreaOMASAPIResponse<Line> lineResponse = this.getTermRelationships(userId, guid, new FindRequest());
        List lines = lineResponse.results();
        for (Line line : lines) {
            if (!line.getLineType().equals((Object)LineType.TermCategorization)) continue;
            deleteCategorizationGuidSet.add(line.getGuid());
        }
        if (deleteCategorizationGuidSet != null && deleteCategorizationGuidSet.size() > 0) {
            for (String categorizationGuidToDelete : deleteCategorizationGuidSet) {
                String typeDefGuid = this.termCategorizationMapper.getTypeDefGuid();
                this.oMRSAPIHelper.callOMRSDeleteRelationship(methodName, userId, typeDefGuid, this.termCategorizationMapper.getTypeName(), categorizationGuidToDelete);
            }
        }
        if ((suppliedCategories = suppliedTerm.getCategories()) != null && suppliedCategories.size() > 0) {
            for (CategorySummary categorySummary : suppliedCategories) {
                this.addCategorizationRelationship(userId, suppliedTerm, methodName, categorySummary.getGuid());
            }
        }
    }

    private void addCategorizationRelationship(String userId, Term suppliedTerm, String methodName, String categoryGuid) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, categoryGuid, this.categoryMapper.getTypeName(), methodName);
        if (entityDetail.isPresent()) {
            Categorization categorization = new Categorization();
            categorization.getEnd1().setNodeGuid(entityDetail.get().getGUID());
            categorization.getEnd2().setNodeGuid(suppliedTerm.getSystemAttributes().getGUID());
            this.oMRSAPIHelper.callOMRSAddRelationship(methodName, userId, this.termCategorizationMapper.map(categorization));
        }
    }

    private Set<String> getCurrentClassificationNames(Term currentTerm) {
        Set<String> currentClassificationNames = currentTerm.getClassifications().stream().map(x -> x.getClassificationName()).collect(Collectors.toSet());
        GovernanceActions currentActions = currentTerm.getGovernanceActions();
        if (currentActions != null) {
            if (currentActions.getConfidence() != null) {
                currentClassificationNames.add(currentActions.getConfidence().getClassificationName());
            }
            if (currentActions.getConfidentiality() != null) {
                currentClassificationNames.add(currentActions.getConfidentiality().getClassificationName());
            }
            if (currentActions.getRetention() != null) {
                currentClassificationNames.add(currentActions.getRetention().getClassificationName());
            }
            if (currentActions.getCriticality() != null) {
                currentClassificationNames.add(currentActions.getCriticality().getClassificationName());
            }
        }
        return currentClassificationNames;
    }

    private void replaceAttributes(Term currentTerm, Term newTerm) {
        currentTerm.setName(newTerm.getName());
        currentTerm.setQualifiedName(newTerm.getQualifiedName());
        currentTerm.setDescription(newTerm.getDescription());
        currentTerm.setAbbreviation(newTerm.getAbbreviation());
        currentTerm.setExamples(newTerm.getExamples());
        currentTerm.setSummary(newTerm.getSummary());
        currentTerm.setUsage(newTerm.getUsage());
        currentTerm.setObjectIdentifier(newTerm.isObjectIdentifier());
        currentTerm.setSpineAttribute(newTerm.isSpineAttribute());
        currentTerm.setSpineObject(newTerm.isSpineObject());
        currentTerm.setAdditionalProperties(newTerm.getAdditionalProperties());
        currentTerm.setClassifications(newTerm.getClassifications());
    }

    private void updateAttributes(Term currentTerm, Term newTerm) {
        if (newTerm.getName() != null) {
            currentTerm.setName(newTerm.getName());
        }
        if (newTerm.getQualifiedName() != null) {
            currentTerm.setQualifiedName(newTerm.getQualifiedName());
        }
        if (newTerm.getDescription() != null) {
            currentTerm.setDescription(newTerm.getDescription());
        }
        if (newTerm.getUsage() != null) {
            currentTerm.setUsage(newTerm.getUsage());
        }
        if (newTerm.getSummary() != null) {
            currentTerm.setSummary(newTerm.getSummary());
        }
        if (newTerm.getAbbreviation() != null) {
            currentTerm.setAbbreviation(newTerm.getAbbreviation());
        }
        if (newTerm.getAdditionalProperties() != null) {
            currentTerm.setAdditionalProperties(newTerm.getAdditionalProperties());
        }
        if (newTerm.getExamples() != null) {
            currentTerm.setExamples(newTerm.getExamples());
        }
        if (newTerm.getClassifications() != null) {
            currentTerm.setClassifications(newTerm.getClassifications());
        }
    }

    public SubjectAreaOMASAPIResponse<Term> deleteTerm(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeEntity("deleteTerm", userId, "GlossaryTerm", guid);
            } else {
                this.oMRSAPIHelper.callOMRSDeleteEntity("deleteTerm", userId, "GlossaryTerm", guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> restoreTerm(String userId, String guid) {
        String methodName = "restoreTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreEntity("restoreTerm", userId, guid);
            response = this.getTermByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getTermCategories(String userId, String guid, SubjectAreaCategoryHandler categoryHandler, Integer startingFrom, Integer pageSize) {
        String methodName = "getTermCategories";
        SubjectAreaOMASAPIResponse<Category> response = this.getRelatedNodesForEnd2("getTermCategories", userId, guid, "TermCategorization", CategoryMapper.class, startingFrom, pageSize);
        ArrayList allCategories = new ArrayList();
        if (response.getRelatedHTTPCode() == 200 && response.results() != null && response.results().size() > 0) {
            for (Category mappedCategory : response.results()) {
                SubjectAreaOMASAPIResponse<Category> categoryResponse = categoryHandler.getCategoryByGuid(userId, mappedCategory.getSystemAttributes().getGUID());
                if (categoryResponse.getRelatedHTTPCode() == 200) {
                    allCategories.add(categoryResponse.results().get(0));
                    continue;
                }
                response = categoryResponse;
                break;
            }
        }
        if (response.getRelatedHTTPCode() == 200) {
            response = new SubjectAreaOMASAPIResponse<Category>();
            response.addAllResults(allCategories);
        }
        return response;
    }
}

