/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph.LineTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph.NodeTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;

public class SubjectAreaGraphHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaGraphHandler.class.getName();

    public SubjectAreaGraphHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        super(oMRSAPIHelper, maxPageSize);
    }

    public SubjectAreaOMASAPIResponse<Graph> getGraph(String userId, String guid, Date asOfTime, String nodeFilterStr, String lineFilterStr, StatusFilter statusFilter, Integer level) {
        String methodName = "getGraph";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            ArrayList<InstanceStatus> requestedInstanceStatus = new ArrayList<InstanceStatus>();
            if (statusFilter == null || statusFilter == StatusFilter.ACTIVE) {
                requestedInstanceStatus.add(SubjectAreaUtils.convertStatusToInstanceStatus(Status.ACTIVE));
            } else {
                for (Status omasStatus : Status.values()) {
                    requestedInstanceStatus.add(SubjectAreaUtils.convertStatusToInstanceStatus(omasStatus));
                }
            }
            if (level == null) {
                level = 3;
            }
            InstanceGraph instanceGraph = this.oMRSAPIHelper.callGetEntityNeighbourhood("getGraph", userId, guid, this.getEntityGuids(nodeFilterStr), this.getRelationshipTypeGuids(lineFilterStr), requestedInstanceStatus, null, asOfTime, level);
            Graph graph = new Graph();
            if (CollectionUtils.isNotEmpty((Collection)instanceGraph.getRelationships())) {
                List<Line> lines = this.getLinesFromRelationships(instanceGraph.getRelationships());
                graph.setLines(new HashSet<Line>(lines));
            }
            if (CollectionUtils.isNotEmpty((Collection)instanceGraph.getEntities())) {
                List<Node> nodes = this.getNodesFromEntityDetails(instanceGraph.getEntities());
                graph.setNodes(new HashSet<Node>(nodes));
            }
            response.addResult((Object)graph);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private List<String> getEntityGuids(String nodeFilterStr) {
        Stream<NodeType> nodeTypeStream = Arrays.stream(NodeType.values());
        if (nodeFilterStr == null) {
            return nodeTypeStream.filter(type -> type != NodeType.Unknown).map(NodeTypeMapper::mapNodeTypeToEntityTypeGuid).collect(Collectors.toList());
        }
        Set typeNames = nodeTypeStream.map(Enum::name).collect(Collectors.toSet());
        return Arrays.stream(nodeFilterStr.split(",")).filter(typeNames::contains).map(NodeType::valueOf).map(NodeTypeMapper::mapNodeTypeToEntityTypeGuid).distinct().collect(Collectors.toList());
    }

    private List<String> getRelationshipTypeGuids(String lineFilterStr) {
        Stream<LineType> lineTypeStream = Arrays.stream(LineType.values());
        if (lineFilterStr == null) {
            return lineTypeStream.filter(type -> type != LineType.Unknown).map(LineTypeMapper::mapLineTypeToRelationshipTypeGuid).collect(Collectors.toList());
        }
        Set typeNames = lineTypeStream.map(Enum::name).collect(Collectors.toSet());
        return Arrays.stream(lineFilterStr.split(",")).filter(typeNames::contains).map(LineType::valueOf).map(LineTypeMapper::mapLineTypeToRelationshipTypeGuid).distinct().collect(Collectors.toList());
    }
}

