/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaConfigHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaProjectHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SubjectAreaServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.SUBJECT_AREA_OMAS;
    private OMRSAPIHelper oMRSAPIHelper;
    private SubjectAreaGlossaryHandler glossaryHandler;
    private SubjectAreaProjectHandler projectHandler;
    private SubjectAreaTermHandler termHandler;
    private SubjectAreaCategoryHandler categoryHandler;
    private SubjectAreaRelationshipHandler relationshipHandler;
    private SubjectAreaGraphHandler graphHandler;
    private SubjectAreaConfigHandler configHandler;

    public SubjectAreaServicesInstance(OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler != null) {
            if (this.oMRSAPIHelper == null) {
                this.oMRSAPIHelper = new OMRSAPIHelper(this.serviceName, this.serverName, this.repositoryHandler, this.repositoryHelper);
            }
        } else {
            throw new NewInstanceException(SubjectAreaErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.glossaryHandler = new SubjectAreaGlossaryHandler(this.oMRSAPIHelper, maxPageSize);
        this.termHandler = new SubjectAreaTermHandler(this.oMRSAPIHelper, maxPageSize);
        this.categoryHandler = new SubjectAreaCategoryHandler(this.oMRSAPIHelper, maxPageSize);
        this.projectHandler = new SubjectAreaProjectHandler(this.oMRSAPIHelper, maxPageSize);
        this.graphHandler = new SubjectAreaGraphHandler(this.oMRSAPIHelper, maxPageSize);
        this.relationshipHandler = new SubjectAreaRelationshipHandler(this.oMRSAPIHelper, maxPageSize);
        this.configHandler = new SubjectAreaConfigHandler(this.oMRSAPIHelper, maxPageSize);
    }

    public SubjectAreaGlossaryHandler getGlossaryHandler() {
        return this.glossaryHandler;
    }

    public SubjectAreaProjectHandler getProjectHandler() {
        return this.projectHandler;
    }

    public SubjectAreaTermHandler getTermHandler() {
        return this.termHandler;
    }

    public SubjectAreaCategoryHandler getCategoryHandler() {
        return this.categoryHandler;
    }

    public SubjectAreaRelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }

    public SubjectAreaGraphHandler getGraphHandler() {
        return this.graphHandler;
    }

    public SubjectAreaConfigHandler getConfigHandler() {
        return this.configHandler;
    }
}

