/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Map;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class SubjectAreaRelationshipHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaRelationshipHandler.class.getName();

    public SubjectAreaRelationshipHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        super(oMRSAPIHelper, maxPageSize);
    }

    public <L extends Line> SubjectAreaOMASAPIResponse<L> createLine(String restAPIName, String userId, Class<? extends ILineMapper<L>> clazz, L line) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            ILineMapper<L> mapper = this.mappersFactory.get(clazz);
            Relationship omrsRelationship = mapper.map(line);
            Optional<Relationship> createdOMRSRelationship = this.oMRSAPIHelper.callOMRSAddRelationship(restAPIName, userId, omrsRelationship);
            if (createdOMRSRelationship.isPresent()) {
                L createdLine = mapper.map(createdOMRSRelationship.get());
                response.addResult(createdLine);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <L extends Line> SubjectAreaOMASAPIResponse<L> getLine(String restAPIName, String userId, Class<? extends ILineMapper<L>> clazz, String guid) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            ILineMapper<L> mapper = this.mappersFactory.get(clazz);
            Optional<Relationship> gotRelationship = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, guid);
            if (gotRelationship.isPresent()) {
                L gotLine = mapper.map(gotRelationship.get());
                response.addResult(gotLine);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <L extends Line> SubjectAreaOMASAPIResponse<L> updateLine(String restAPIName, String userId, String lineGuid, Class<? extends ILineMapper<L>> clazz, L line, Boolean isReplace) {
        SubjectAreaOMASAPIResponse<L> response = new SubjectAreaOMASAPIResponse<L>();
        try {
            ILineMapper<L> mapper = this.mappersFactory.get(clazz);
            Optional<Relationship> gotRelationship = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, lineGuid);
            if (gotRelationship.isPresent()) {
                Relationship originalRelationship = gotRelationship.get();
                Relationship relationshipToUpdate = mapper.map(line);
                relationshipToUpdate.setGUID(lineGuid);
                if (relationshipToUpdate.getProperties() == null || relationshipToUpdate.getProperties().getPropertyCount() == 0) {
                    ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.LINE_UPDATE_ATTEMPTED_WITH_NO_PROPERTIES.getMessageDefinition();
                    throw new InvalidParameterException(messageDefinition, className, restAPIName, "properties", null);
                }
                if (!isReplace.booleanValue()) {
                    InstanceProperties instanceProperties = this.updateProperties(originalRelationship, relationshipToUpdate);
                    instanceProperties.setEffectiveFromTime(line.getEffectiveFromTime());
                    instanceProperties.setEffectiveToTime(line.getEffectiveToTime());
                    relationshipToUpdate.setProperties(instanceProperties);
                }
                this.oMRSAPIHelper.callOMRSUpdateRelationship(restAPIName, userId, relationshipToUpdate);
                response = this.getLine(restAPIName, userId, clazz, lineGuid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private InstanceProperties updateProperties(Relationship originalRelationship, Relationship relationshipToUpdate) {
        Map updateInstanceProperties = relationshipToUpdate.getProperties().getInstanceProperties();
        if (originalRelationship.getProperties() != null) {
            Map orgInstanceProperties = originalRelationship.getProperties().getInstanceProperties();
            for (String orgPropertyName : orgInstanceProperties.keySet()) {
                if (updateInstanceProperties.containsKey(orgPropertyName)) continue;
                updateInstanceProperties.put(orgPropertyName, orgInstanceProperties.get(orgPropertyName));
            }
        }
        InstanceProperties instancePropertiesToUpdate = new InstanceProperties();
        instancePropertiesToUpdate.setInstanceProperties(updateInstanceProperties);
        return instancePropertiesToUpdate;
    }

    public <L extends Line> SubjectAreaOMASAPIResponse<L> deleteLine(String restAPIName, String userId, Class<? extends ILineMapper<L>> clazz, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            ILineMapper<L> mapper = this.mappersFactory.get(clazz);
            String typeGuid = mapper.getTypeDefGuid();
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeRelationship(restAPIName, userId, typeGuid, mapper.getTypeName(), guid);
            } else {
                this.oMRSAPIHelper.callOMRSDeleteRelationship(restAPIName, userId, typeGuid, mapper.getTypeName(), guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <L extends Line> SubjectAreaOMASAPIResponse<L> restoreLine(String restAPIName, String userId, Class<? extends ILineMapper<L>> clazz, String guid) {
        SubjectAreaOMASAPIResponse<L> response = new SubjectAreaOMASAPIResponse<L>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreRelationship(restAPIName, userId, guid);
            response = this.getLine(restAPIName, userId, clazz, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

