/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGraphRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final String className = SubjectAreaGraphRESTServices.class.getName();
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGraphRESTServices.class);
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    public SubjectAreaOMASAPIResponse<Graph> getGraph(String serverName, String userId, String guid, Date asOfTime, String nodeFilterStr, String lineFilterStr, StatusFilter statusFilter, Integer level) {
        String methodName = "getGraph";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGraph,userId=" + userId + ",guid=" + guid);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGraph");
            SubjectAreaGraphHandler handler = instanceHandler.getSubjectAreaGraphHandler(userId, serverName, "getGraph");
            response = handler.getGraph(userId, guid, asOfTime, nodeFilterStr, lineFilterStr, statusFilter, level);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGraph");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGraph,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

