/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.CriticalityLevel;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ClassificationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriticalityMapper
extends ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(CriticalityMapper.class);
    private static final String className = CriticalityMapper.class.getName();
    private static final String typeName = "Criticality";

    public CriticalityMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected Set<String> mapKnownAttributesToOmrs(Classification omasClassification, InstanceProperties omrsClassificationProperties) {
        Criticality criticality = (Criticality)omasClassification;
        String stringValue = this.repositoryHelper.getStringProperty(this.omrsapiHelper.getServiceName(), "steward", omrsClassificationProperties, "");
        criticality.setSteward(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.omrsapiHelper.getServiceName(), "source", omrsClassificationProperties, "");
        criticality.setSource(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.omrsapiHelper.getServiceName(), "notes", omrsClassificationProperties, "");
        criticality.setNotes(stringValue);
        Integer intValue = this.repositoryHelper.getIntProperty(this.omrsapiHelper.getServiceName(), "confidence", omrsClassificationProperties, "");
        criticality.setConfidence(intValue);
        Map instancePropertyMap = omrsClassificationProperties.getInstanceProperties();
        InstancePropertyValue instancePropertyValue = (InstancePropertyValue)instancePropertyMap.get("level");
        if (instancePropertyValue != null) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            CriticalityLevel level = CriticalityLevel.valueOf((String)enumPropertyValue.getSymbolicName());
            criticality.setLevel(level);
        }
        return Criticality.PROPERTY_NAMES_SET;
    }

    @Override
    protected String getTypeName() {
        return typeName;
    }

    @Override
    protected Classification createOmasClassification() {
        return new Criticality();
    }

    @Override
    protected InstanceProperties updateOMRSAttributes(Classification omasClassification) {
        InstanceProperties instanceProperties = new InstanceProperties();
        Criticality criticality = (Criticality)omasClassification;
        if (criticality.getSteward() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "steward", criticality.getSteward(), "updateOMRSAttributes");
        }
        if (criticality.getSource() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "source", criticality.getSource(), "updateOMRSAttributes");
        }
        if (criticality.getNotes() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "notes", criticality.getNotes(), "updateOMRSAttributes");
        }
        if (criticality.getConfidence() != null) {
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
            primitivePropertyValue.setPrimitiveValue((Object)criticality.getConfidence());
            instanceProperties.setProperty("confidence", (InstancePropertyValue)primitivePropertyValue);
        }
        if (criticality.getLevel() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(criticality.getLevel().getOrdinal());
            enumPropertyValue.setSymbolicName(criticality.getLevel().getName());
            instanceProperties.setProperty("level", (InstancePropertyValue)enumPropertyValue);
        }
        return instanceProperties;
    }
}

