/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(RelationshipTypeMapper.class);
    private static final String className = RelationshipTypeMapper.class.getName();

    public static String mapOMASRelationshipTypeToOMRSRelationshipTypeGuid(RelationshipType omasRelationshipType) {
        String relationshipTypeName = omasRelationshipType.name();
        if (omasRelationshipType.equals((Object)RelationshipType.HasA)) {
            relationshipTypeName = "TermHASARelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.IsA)) {
            relationshipTypeName = "ISARelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.IsATypeOf)) {
            relationshipTypeName = "TermISATypeOFRelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.TypedBy)) {
            relationshipTypeName = "TermTYPEDBYRelationship";
        }
        return OpenMetadataTypesArchiveAccessor.getInstance().getRelationshipDefByName(relationshipTypeName).getGUID();
    }
}

