/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.NodeSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaUtils {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaUtils.class);
    private static final String className = SubjectAreaUtils.class.getName();

    public static InstanceType createTemplateFromTypeDef(TypeDef typeDef) {
        InstanceType template = new InstanceType();
        template.setTypeDefName(typeDef.getName());
        template.setTypeDefCategory(typeDef.getCategory());
        template.setTypeDefDescription(typeDef.getDescription());
        template.setTypeDefDescriptionGUID(typeDef.getDescriptionGUID());
        template.setTypeDefGUID(typeDef.getGUID());
        ArrayList<TypeDefLink> supertypes = new ArrayList<TypeDefLink>();
        supertypes.add(typeDef.getSuperType());
        template.setTypeDefSuperTypes(supertypes);
        template.setTypeDefVersion(typeDef.getVersion());
        template.setValidStatusList(typeDef.getValidInstanceStatusList());
        return template;
    }

    public static CategorySummary extractCategorySummaryFromCategory(Category category, Relationship relationship) {
        CategorySummary categorySummary = new CategorySummary();
        SubjectAreaUtils.extractNodeSummary((Node)category, relationship, (NodeSummary)categorySummary);
        return categorySummary;
    }

    private static void extractNodeSummary(Node node, Relationship relationship, NodeSummary nodeSummary) {
        nodeSummary.setQualifiedName(node.getQualifiedName());
        nodeSummary.setName(node.getName());
        nodeSummary.setGuid(node.getSystemAttributes().getGUID());
        nodeSummary.setFromEffectivityTime(node.getEffectiveFromTime());
        nodeSummary.setToEffectivityTime(node.getEffectiveToTime());
        nodeSummary.setRelationshipguid(relationship.getGuid());
        nodeSummary.setFromRelationshipEffectivityTime(relationship.getEffectiveFromTime());
        nodeSummary.setToRelationshipEffectivityTime(relationship.getEffectiveToTime());
    }

    public static GlossarySummary extractGlossarySummaryFromGlossary(Glossary glossary, Relationship relationship) {
        if (glossary == null) {
            return null;
        }
        GlossarySummary glossarySummary = new GlossarySummary();
        SubjectAreaUtils.extractNodeSummary((Node)glossary, relationship, (NodeSummary)glossarySummary);
        return glossarySummary;
    }

    public static String getGlossaryGuidFromAnchor(Relationship relationship) {
        String glossaryGuid = null;
        if (relationship instanceof TermAnchor || relationship instanceof CategoryAnchor) {
            glossaryGuid = relationship.getEnd1().getNodeGuid();
        }
        return glossaryGuid;
    }

    public static void checkStatusNotDeleted(Status status, SubjectAreaErrorCode errorCode) throws InvalidParameterException {
        String methodName = "checkStatusNotDeleted";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: checkStatusNotDeleted");
        }
        if (status.equals((Object)Status.DELETED)) {
            String propertyName = "Status";
            String propertyValue = Status.DELETED.name();
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{propertyName, propertyValue});
            throw new InvalidParameterException(messageDefinition, className, "checkStatusNotDeleted", propertyName, propertyValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: checkStatusNotDeleted");
        }
    }

    public static Status convertInstanceStatusToStatus(InstanceStatus instanceStatus) {
        Status status = null;
        if (instanceStatus == null) {
            status = Status.ACTIVE;
        } else {
            switch (instanceStatus) {
                case ACTIVE: {
                    status = Status.ACTIVE;
                    break;
                }
                case DELETED: {
                    status = Status.DELETED;
                    break;
                }
                case DRAFT: {
                    status = Status.DRAFT;
                    break;
                }
                case UNKNOWN: {
                    status = Status.UNKNOWN;
                    break;
                }
                case PREPARED: {
                    status = Status.PREPARED;
                    break;
                }
                case PROPOSED: {
                    status = Status.PROPOSED;
                    break;
                }
                case APPROVED: {
                    status = Status.APPROVED;
                }
            }
        }
        return status;
    }

    public static InstanceStatus convertStatusToInstanceStatus(Status status) {
        InstanceStatus instanceStatus = null;
        if (status == null) {
            instanceStatus = InstanceStatus.ACTIVE;
        } else {
            switch (status) {
                case ACTIVE: {
                    instanceStatus = InstanceStatus.ACTIVE;
                    break;
                }
                case DELETED: {
                    instanceStatus = InstanceStatus.DELETED;
                    break;
                }
                case DRAFT: {
                    instanceStatus = InstanceStatus.DRAFT;
                    break;
                }
                case UNKNOWN: {
                    instanceStatus = InstanceStatus.UNKNOWN;
                    break;
                }
                case PREPARED: {
                    instanceStatus = InstanceStatus.PREPARED;
                    break;
                }
                case PROPOSED: {
                    instanceStatus = InstanceStatus.PROPOSED;
                    break;
                }
                case APPROVED: {
                    instanceStatus = InstanceStatus.APPROVED;
                }
            }
        }
        return instanceStatus;
    }

    public static SystemAttributes createSystemAttributes(InstanceHeader instanceHeader) {
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = instanceHeader.getStatus();
        Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omas_status);
        systemAttributes.setCreatedBy(instanceHeader.getCreatedBy());
        systemAttributes.setUpdatedBy(instanceHeader.getUpdatedBy());
        Date createTimeDate = instanceHeader.getCreateTime();
        Long createTimeLong = null;
        if (createTimeDate != null) {
            createTimeLong = createTimeDate.getTime();
        }
        systemAttributes.setCreateTime(createTimeLong);
        Date updateTimeDate = instanceHeader.getUpdateTime();
        Long updateTimeLong = null;
        if (updateTimeDate != null) {
            updateTimeLong = updateTimeDate.getTime();
        }
        systemAttributes.setUpdateTime(updateTimeLong);
        systemAttributes.setVersion(Long.valueOf(instanceHeader.getVersion()));
        systemAttributes.setGUID(instanceHeader.getGUID());
        return systemAttributes;
    }

    public static void populateSystemAttributesForInstanceAuditHeader(SystemAttributes systemAttributes, InstanceAuditHeader instanceAuditHeader) {
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                instanceAuditHeader.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                instanceAuditHeader.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                instanceAuditHeader.setCreateTime(new Date(systemAttributes.getCreateTime()));
            }
            if (systemAttributes.getUpdateTime() != null) {
                instanceAuditHeader.setUpdateTime(new Date(systemAttributes.getUpdateTime()));
            }
            if (systemAttributes.getVersion() != null) {
                instanceAuditHeader.setVersion(systemAttributes.getVersion().longValue());
            }
        }
    }

    public static void setStringPropertyInInstanceProperties(InstanceProperties instanceProperties, String stringValue, String propertyName) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)stringValue);
        instanceProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
    }

    public static void setIntegerPropertyInInstanceProperties(InstanceProperties instanceProperties, Integer integerValue, String propertyName) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        primitivePropertyValue.setPrimitiveValue((Object)integerValue);
        instanceProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
    }

    public static void setDatePropertyInInstanceProperties(InstanceProperties instanceProperties, Date date, String propertyName) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        Long timestamp = date.getTime();
        primitivePropertyValue.setPrimitiveValue((Object)timestamp);
        instanceProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
    }

    public SubjectAreaOMASAPIResponse<IconSummary> getIconSummarySet(String userId, String guid) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        HashSet icons = new HashSet();
        response.addAllResults(icons);
        return response;
    }
}

