/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.IRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

public class SubjectAreaRelationshipHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaRelationshipHandler.class.getName();

    public SubjectAreaRelationshipHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        super(oMRSAPIHelper, maxPageSize);
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> createRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, R relationship) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            Optional<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> createdOMRSRelationship;
            Date effectiveFromtime;
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship omrsRelationship = mapper.map(relationship);
            InstanceProperties instanceProperties = omrsRelationship.getProperties();
            if (instanceProperties == null) {
                instanceProperties = new InstanceProperties();
            }
            if ((effectiveFromtime = instanceProperties.getEffectiveFromTime()) == null) {
                instanceProperties.setEffectiveFromTime(new Date());
                omrsRelationship.setProperties(instanceProperties);
            }
            if ((createdOMRSRelationship = this.oMRSAPIHelper.callOMRSAddRelationship(restAPIName, userId, omrsRelationship)).isPresent()) {
                R createdrelationship = mapper.map(createdOMRSRelationship.get());
                response.addResult(createdrelationship);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> getRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, String guid) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            Optional<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> gotOMRSRelationship = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, guid);
            if (gotOMRSRelationship.isPresent()) {
                R omasRelationship = mapper.map(gotOMRSRelationship.get());
                response.addResult(omasRelationship);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> updateRelationship(String restAPIName, String userId, String relationshipGuid, Class<? extends IRelationshipMapper<R>> clazz, R relationship, Boolean isReplace) {
        String methodName = "updateRelationship";
        SubjectAreaOMASAPIResponse<R> response = new SubjectAreaOMASAPIResponse<R>();
        try {
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            Optional<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> gotRelationship = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, relationshipGuid);
            if (gotRelationship.isPresent()) {
                this.checkRelationshipReadOnly("updateRelationship", gotRelationship.get(), "update");
                org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship originalRelationship = gotRelationship.get();
                org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationshipToUpdate = mapper.map(relationship);
                relationshipToUpdate.setGUID(relationshipGuid);
                if (relationshipToUpdate.getProperties() == null || relationshipToUpdate.getProperties().getPropertyCount() == 0) {
                    ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.RELATIONSHIP_UPDATE_ATTEMPTED_WITH_NO_PROPERTIES.getMessageDefinition();
                    throw new InvalidParameterException(messageDefinition, className, restAPIName, "properties", null);
                }
                if (!isReplace.booleanValue()) {
                    InstanceProperties instanceProperties = this.updateProperties(originalRelationship, relationshipToUpdate);
                    if (relationship.getEffectiveFromTime() != null) {
                        instanceProperties.setEffectiveFromTime(new Date(relationship.getEffectiveFromTime()));
                    }
                    if (relationship.getEffectiveToTime() != null) {
                        instanceProperties.setEffectiveToTime(new Date(relationship.getEffectiveToTime()));
                    }
                    relationshipToUpdate.setProperties(instanceProperties);
                }
                this.oMRSAPIHelper.callOMRSUpdateRelationship(restAPIName, userId, relationshipToUpdate);
                response = this.getRelationship(restAPIName, userId, clazz, relationshipGuid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private InstanceProperties updateProperties(org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship originalRelationship, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationshipToUpdate) {
        Map updateInstanceProperties = relationshipToUpdate.getProperties().getInstanceProperties();
        if (originalRelationship.getProperties() != null) {
            Map orgInstanceProperties = originalRelationship.getProperties().getInstanceProperties();
            for (String orgPropertyName : orgInstanceProperties.keySet()) {
                if (updateInstanceProperties.containsKey(orgPropertyName)) continue;
                updateInstanceProperties.put(orgPropertyName, (InstancePropertyValue)orgInstanceProperties.get(orgPropertyName));
            }
        }
        InstanceProperties instancePropertiesToUpdate = new InstanceProperties();
        instancePropertiesToUpdate.setInstanceProperties(updateInstanceProperties);
        return instancePropertiesToUpdate;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> deleteRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, String guid, Boolean isPurge) {
        String methodName = "deleteRelationship";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            String typeGuid = mapper.getTypeDefGuid();
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeRelationship(restAPIName, userId, typeGuid, mapper.getTypeName(), guid);
            } else {
                Optional<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> gotRelationship = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, guid);
                if (gotRelationship.isPresent()) {
                    this.checkRelationshipReadOnly("deleteRelationship", gotRelationship.get(), "delete");
                }
                this.oMRSAPIHelper.callOMRSDeleteRelationship(restAPIName, userId, typeGuid, mapper.getTypeName(), guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> restoreRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, String guid) {
        SubjectAreaOMASAPIResponse<R> response = new SubjectAreaOMASAPIResponse<R>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreRelationship(restAPIName, userId, guid);
            response = this.getRelationship(restAPIName, userId, clazz, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

