/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaProjectHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaProjectRESTServices.class);
    private static final String className = SubjectAreaProjectRESTServices.class.getName();
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    public SubjectAreaOMASAPIResponse<Project> createProject(String serverName, String userId, Project suppliedProject) {
        String methodName = "createProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProject,userId=" + userId);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProject");
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "createProject");
            response = handler.createProject(userId, suppliedProject);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "createProject");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> getProjectByGuid(String serverName, String userId, String guid) {
        String methodName = "getProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectByGuid,userId=" + userId + ",guid=" + guid);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectByGuid");
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "getProjectByGuid");
            response = handler.getProjectByGuid(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getProjectByGuid");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectByGuid,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> findProject(String serverName, String userId, String searchCriteria, boolean exactValue, boolean ignoreCase, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findProject,userId=" + userId);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProject");
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "findProject");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.findProject(userId, findRequest, exactValue, ignoreCase);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "findProject");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getProjectRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, methodName);
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.getProjectRelationships(userId, guid, findRequest);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, methodName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getProjectTerms(String serverName, String userId, String guid, Integer startingFrom, Integer pageSize) {
        String methodName = "getProjectTerms";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            SubjectAreaProjectHandler projectHandler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, methodName);
            response = projectHandler.getProjectTerms(userId, guid, instanceHandler.getSubjectAreaTermHandler(userId, serverName, methodName), startingFrom, pageSize);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, methodName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> updateProject(String serverName, String userId, String guid, Project suppliedProject, boolean isReplace) {
        String methodName = "updateProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProject,userId=" + userId + ",guid=" + guid);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProject");
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "updateProject");
            response = handler.updateProject(userId, guid, suppliedProject, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "updateProject");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> deleteProject(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProject,userId=" + userId + ",guid=" + guid);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteProject");
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "deleteProject");
            response = handler.deleteProject(userId, guid, isPurge);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "deleteProject");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> restoreProject(String serverName, String userId, String guid) {
        String methodName = "restoreProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProject,userId=" + userId + ",guid=" + guid);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreProject");
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "restoreProject");
            response = handler.restoreProject(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "restoreProject");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

