/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.IRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph.NodeTypeMapper;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

public class SubjectAreaRelationshipHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaRelationshipHandler.class.getName();

    public SubjectAreaRelationshipHandler(OpenMetadataAPIGenericHandler genericHandler, int maxPageSize) {
        super(genericHandler, maxPageSize);
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> createRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, R relationship) {
        SubjectAreaOMASAPIResponse<R> response = new SubjectAreaOMASAPIResponse<R>();
        try {
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship omrsRelationship = mapper.map(relationship);
            InstanceProperties instanceProperties = omrsRelationship.getProperties();
            if (instanceProperties == null) {
                instanceProperties = new InstanceProperties();
            }
            String proxy1TypeName = NodeTypeMapper.mapNodeTypeNameToEntityTypeName(relationship.getEnd1().getNodeTypeName());
            String proxy2TypeName = NodeTypeMapper.mapNodeTypeNameToEntityTypeName(relationship.getEnd2().getNodeTypeName());
            this.invalidParameterHandler.validateTypeName(proxy1TypeName, proxy1TypeName, this.genericHandler.getServiceName(), restAPIName, this.genericHandler.getRepositoryHelper());
            this.invalidParameterHandler.validateTypeName(proxy2TypeName, proxy2TypeName, this.genericHandler.getServiceName(), restAPIName, this.genericHandler.getRepositoryHelper());
            String guid = this.genericHandler.linkElementToElement(userId, null, null, omrsRelationship.getEntityOneProxy().getGUID(), "end1.guid", proxy1TypeName, omrsRelationship.getEntityTwoProxy().getGUID(), "end2.guid", proxy2TypeName, false, false, omrsRelationship.getType().getTypeDefGUID(), omrsRelationship.getType().getTypeDefName(), instanceProperties, restAPIName);
            response = this.getRelationship(restAPIName, userId, clazz, guid);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> getRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, String guid) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            String typeDefName = mapper.getTypeName();
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship oMRSRelationship = this.genericHandler.getRepositoryHandler().getRelationshipByGUID(userId, guid, "guid", typeDefName, null, restAPIName);
            R omasRelationship = mapper.map(oMRSRelationship);
            response.addResult(omasRelationship);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> updateRelationship(String restAPIName, String userId, String relationshipGuid, Class<? extends IRelationshipMapper<R>> clazz, R relationship, Boolean isReplace) {
        String methodName = "updateRelationship";
        SubjectAreaOMASAPIResponse<R> response = new SubjectAreaOMASAPIResponse<R>();
        try {
            IRelationshipMapper<Relationship> mapper = this.mappersFactory.get(clazz);
            response = this.getRelationship("updateRelationship", userId, clazz, relationshipGuid);
            Relationship storedOMASRelationship = (Relationship)response.results().get(0);
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship storedRelationship = mapper.map(storedOMASRelationship);
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationshipToUpdate = mapper.map(relationship);
            relationshipToUpdate.setGUID(relationshipGuid);
            this.genericHandler.updateRelationshipProperties(userId, null, null, relationshipGuid, "guid", mapper.getTypeName(), isReplace == false, relationshipToUpdate.getProperties(), "updateRelationship");
            Date requestedEffectiveFrom = relationship.getEffectiveFromTime() == null ? null : new Date(relationship.getEffectiveFromTime());
            Date requestedEffectiveTo = relationship.getEffectiveToTime() == null ? null : new Date(relationship.getEffectiveToTime());
            Date storedEffectiveFrom = storedRelationship.getProperties().getEffectiveFromTime();
            Date storedEffectiveTo = storedRelationship.getProperties().getEffectiveToTime();
            if (!isReplace.booleanValue()) {
                if (requestedEffectiveFrom == null && storedEffectiveFrom != null) {
                    requestedEffectiveFrom = storedEffectiveFrom;
                }
                if (requestedEffectiveTo == null && storedEffectiveTo != null) {
                    requestedEffectiveTo = storedEffectiveTo;
                }
            }
            this.genericHandler.updateRelationshipEffectivityDates(userId, null, null, relationshipGuid, "guid", mapper.getTypeName(), requestedEffectiveFrom, requestedEffectiveTo, "updateRelationship");
            response = this.getRelationship(restAPIName, userId, clazz, relationshipGuid);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> deleteRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, String guid) {
        String methodName = "deleteRelationship";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            IRelationshipMapper<R> mapper = this.mappersFactory.get(clazz);
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship oMRSRelationship = this.genericHandler.getRepositoryHandler().getRelationshipByGUID(userId, guid, "guid", mapper.getTypeName(), null, restAPIName);
            this.genericHandler.unlinkElementFromElement(userId, false, null, null, oMRSRelationship.getEntityOneProxy().getGUID(), "end1,guid", oMRSRelationship.getEntityOneProxy().getType().getTypeDefName(), oMRSRelationship.getEntityTwoProxy().getGUID(), "end2,guid", oMRSRelationship.getEntityTwoProxy().getType().getTypeDefGUID(), oMRSRelationship.getEntityTwoProxy().getType().getTypeDefName(), false, false, oMRSRelationship.getType().getTypeDefName(), oMRSRelationship, "deleteRelationship");
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public <R extends Relationship> SubjectAreaOMASAPIResponse<R> restoreRelationship(String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, String guid) {
        SubjectAreaOMASAPIResponse<R> response = new SubjectAreaOMASAPIResponse<R>();
        try {
            this.genericHandler.getRepositoryHandler().restoreRelationship(userId, null, null, guid, restAPIName);
            response = this.getRelationship(restAPIName, userId, clazz, guid);
        }
        catch (PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

