/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaAuditCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.IRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRESTServicesInstance {
    private static final String className = SubjectAreaRelationshipHandler.class.getName();
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRESTServicesInstance.class);
    protected static SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    protected <R extends Relationship> SubjectAreaOMASAPIResponse<R> createRelationship(String serverName, String restAPIName, String userId, Class<? extends IRelationshipMapper<R>> clazz, R relationship) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.createRelationship(restAPIName, userId, clazz, relationship);
            if (response.results().size() > 0) {
                Relationship createdRelationship = (Relationship)response.results().get(0);
                String relationshipName = createdRelationship.getName();
                SubjectAreaTermHandler termHandler = instanceHandler.getSubjectAreaTermHandler(userId, serverName, restAPIName);
                String end1Guid = createdRelationship.getEnd1().getNodeGuid();
                String end2Guid = createdRelationship.getEnd2().getNodeGuid();
                if (relationshipName.equals(RelationshipType.HasA.name()) || relationshipName.equals(RelationshipType.TypedBy.name())) {
                    SubjectAreaOMASAPIResponse<Term> end1TermResponse = termHandler.getTermByGuid(userId, end1Guid);
                    SubjectAreaOMASAPIResponse<Term> end2TermResponse = termHandler.getTermByGuid(userId, end2Guid);
                    Term end1Term = (Term)end1TermResponse.results().get(0);
                    Term end2Term = (Term)end2TermResponse.results().get(0);
                    if (!end1Term.isSpineObject()) {
                        end1Term.setSpineObject(true);
                        termHandler.updateTerm(userId, end1Guid, end1Term, handler, false);
                    }
                    if (!end2Term.isSpineAttribute()) {
                        end2Term.setSpineAttribute(true);
                        termHandler.updateTerm(userId, end2Guid, end2Term, handler, false);
                    }
                } else if (relationshipName.equals(RelationshipType.IsATypeOf.name())) {
                    SubjectAreaOMASAPIResponse<Term> end1TermResponse = termHandler.getTermByGuid(userId, end1Guid);
                    SubjectAreaOMASAPIResponse<Term> end2TermResponse = termHandler.getTermByGuid(userId, end2Guid);
                    Term end1Term = (Term)end1TermResponse.results().get(0);
                    Term end2Term = (Term)end2TermResponse.results().get(0);
                    if (!end1Term.isSpineObject()) {
                        end1Term.setSpineObject(true);
                        termHandler.updateTerm(userId, end1Guid, end1Term, handler, false);
                    }
                    if (!end2Term.isSpineObject()) {
                        end2Term.setSpineObject(true);
                        termHandler.updateTerm(userId, end2Guid, end2Term, handler, false);
                    }
                }
            }
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, restAPIName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected <L extends Relationship> SubjectAreaOMASAPIResponse<L> getRelationship(String serverName, String restAPIName, String userId, Class<? extends IRelationshipMapper<L>> clazz, String guid) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.getRelationship(restAPIName, userId, clazz, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, restAPIName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected <L extends Relationship> SubjectAreaOMASAPIResponse<L> updateRelationship(String serverName, String restAPIName, String userId, String guid, Class<? extends IRelationshipMapper<L>> clazz, L relationship, boolean isReplace) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.updateRelationship(restAPIName, userId, guid, clazz, relationship, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, restAPIName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    public <L extends Relationship> SubjectAreaOMASAPIResponse<L> deleteRelationship(String serverName, String restAPIName, String userId, Class<? extends IRelationshipMapper<L>> clazz, String guid) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.deleteRelationship(restAPIName, userId, clazz, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, restAPIName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected <L extends Relationship> SubjectAreaOMASAPIResponse<L> restoreRelationship(String serverName, String restAPIName, String userId, Class<? extends IRelationshipMapper<L>> clazz, String guid) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.restoreRelationship(restAPIName, userId, clazz, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, restAPIName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected FindRequest getFindRequest(String searchCriteria, Date asOfTime, Integer startingFrom, Integer pageSize, String sequencingOrderName, String sequencingProperty, Integer handlerMaxPageSize) {
        FindRequest findRequest = new FindRequest();
        SequencingOrder sequencingOrder = SequencingOrder.ANY;
        for (SequencingOrder possibleSequence : SequencingOrder.values()) {
            if (!possibleSequence.name().equals(sequencingOrderName)) continue;
            sequencingOrder = possibleSequence;
        }
        findRequest.setSearchCriteria(searchCriteria);
        findRequest.setAsOfTime(asOfTime);
        findRequest.setStartingFrom(startingFrom.intValue());
        if (pageSize == null) {
            findRequest.setPageSize(handlerMaxPageSize);
        } else {
            findRequest.setPageSize(pageSize);
        }
        findRequest.setSequencingOrder(sequencingOrder);
        findRequest.setSequencingProperty(sequencingProperty);
        return findRequest;
    }

    protected <T> SubjectAreaOMASAPIResponse<T> getResponseForException(Exception exception, AuditLog auditLog, String className, String restAPIName) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        if (exception instanceof OCFCheckedExceptionBase) {
            response.setExceptionInfo((OCFCheckedExceptionBase)((Object)exception), className);
        } else {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition();
            messageDefinition.setMessageParameters(new String[]{exception.getMessage()});
            SubjectAreaCheckedException checkedException = new SubjectAreaCheckedException(messageDefinition, className, restAPIName, exception);
            response.setExceptionInfo((OCFCheckedExceptionBase)((Object)checkedException), className);
            if (auditLog != null) {
                auditLog.logException(restAPIName, SubjectAreaAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{exception.getClass().getName(), restAPIName, exception.getMessage()}), (Throwable)exception);
            }
        }
        return response;
    }
}

