/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryHandler
extends SubjectAreaHandler {
    private static Class<SubjectAreaGlossaryHandler> clazz = SubjectAreaGlossaryHandler.class;
    String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);

    public SubjectAreaGlossaryHandler(OpenMetadataAPIGenericHandler genericHandler, int maxPageSize) {
        super(genericHandler, maxPageSize);
    }

    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{this.className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            String suppliedGlossaryName = suppliedGlossary.getName();
            if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, this.className, "createGlossary", "name");
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedGlossary);
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (suppliedGlossary.getEffectiveFromTime() != null) {
                effectiveFrom = new Date(suppliedGlossary.getEffectiveFromTime());
            }
            if (suppliedGlossary.getEffectiveToTime() != null) {
                effectiveTo = new Date(suppliedGlossary.getEffectiveToTime());
            }
            GlossaryBuilder builder = new GlossaryBuilder(suppliedGlossary.getQualifiedName(), suppliedGlossary.getName(), suppliedGlossary.getDescription(), suppliedGlossary.getLanguage(), suppliedGlossary.getUsage(), this.genericHandler.getRepositoryHelper(), this.genericHandler.getServiceName(), this.genericHandler.getServerName());
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            String guid = this.genericHandler.createBeanInRepository(userId, null, null, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", null, null, (OpenMetadataAPIGenericBuilder)builder, null, "createGlossary");
            if (suppliedGlossary.getNodeType() == NodeType.Taxonomy || suppliedGlossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                this.genericHandler.setClassificationInRepository(userId, null, null, guid, "guid", "Glossary", "37116c51-e6c9-4c37-942e-35d48c8c69a0", "Taxonomy", null, false, false, false, null, "createGlossary");
            }
            if (suppliedGlossary.getNodeType() == NodeType.CanonicalGlossary || suppliedGlossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                this.genericHandler.setClassificationInRepository(userId, null, null, guid, "guid", "Glossary", "33ad3da2-0910-47be-83f1-daee018a4c05", "CanonicalVocabulary", null, false, false, false, null, "createGlossary");
            }
            response = this.getGlossaryByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> getGlossaryByGuid(String userId, String guid) {
        String methodName = "getGlossaryByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            InputValidator.validateGUIDNotNull((String)this.className, (String)"getGlossaryByGuid", (String)guid, (String)"guid");
            EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, guid, "guid", "Glossary", null, null, false, false, null, "getGlossaryByGuid");
            GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
            response.addResult((Object)glossaryMapper.map(entityDetail));
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        String methodName = "findGlossary";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundGlossaries = this.findNodes(userId, "Glossary", "36f66863-9726-4b41-97ee-714fd0dc6fe4", findRequest, exactValue, ignoreCase, GlossaryMapper.class, "findGlossary");
            if (foundGlossaries == null) {
                return response;
            }
            response.addAllResults(foundGlossaries);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getGlossaryRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getGlossaryRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest, "Glossary");
    }

    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{this.className, "updateGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (suppliedGlossary.getEffectiveFromTime() != null) {
                effectiveFrom = new Date(suppliedGlossary.getEffectiveFromTime());
            }
            if (suppliedGlossary.getEffectiveToTime() != null) {
                effectiveTo = new Date(suppliedGlossary.getEffectiveToTime());
            }
            GlossaryBuilder builder = new GlossaryBuilder(suppliedGlossary.getQualifiedName(), suppliedGlossary.getName(), suppliedGlossary.getDescription(), suppliedGlossary.getLanguage(), suppliedGlossary.getUsage(), this.genericHandler.getRepositoryHelper(), this.genericHandler.getServiceName(), this.genericHandler.getServerName());
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            this.genericHandler.updateBeanInRepository(userId, null, null, guid, "guid", "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", false, false, builder.getInstanceProperties("updateGlossary"), !isReplace, null, "updateGlossary");
            response = this.getGlossaryByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(String userId, String guid) {
        String methodName = "deleteGlossary";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        boolean issueDelete = false;
        try {
            if (!this.genericHandler.isBeanIsolated(userId, guid, "Glossary", false, false, null, "deleteGlossary")) {
                throw new EntityNotDeletedException(SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE.getMessageDefinition(new String[]{guid}), this.className, "deleteGlossary", guid);
            }
            issueDelete = true;
            if (issueDelete) {
                this.genericHandler.deleteBeanInRepository(userId, null, null, guid, "guid", "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", null, null, false, false, null, "deleteGlossary");
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(String userId, String guid) {
        String methodName = "restoreGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            this.genericHandler.getRepositoryHandler().restoreEntity(userId, null, null, guid, "restoreGlossary");
            response = this.getGlossaryByGuid(userId, guid);
        }
        catch (PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getTerms(String userId, String guid, SubjectAreaTermHandler termHandler, FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        SubjectAreaOMASAPIResponse<Glossary> thisGlossaryResponse;
        String methodName = "getTerms";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        Integer pageSize = findRequest.getPageSize();
        Integer requestedStartingFrom = findRequest.getStartingFrom();
        String searchCriteria = findRequest.getSearchCriteria();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (requestedStartingFrom == null) {
            requestedStartingFrom = 0;
        }
        if ((thisGlossaryResponse = this.getGlossaryByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            try {
                HashSet<String> specificMatchPropertyNames = new HashSet<String>();
                specificMatchPropertyNames.add("displayName");
                specificMatchPropertyNames.add("description");
                specificMatchPropertyNames.add("qualifiedName");
                specificMatchPropertyNames.add("summary");
                specificMatchPropertyNames.add("examples");
                specificMatchPropertyNames.add("abbreviation");
                specificMatchPropertyNames.add("usage");
                List entities = this.genericHandler.getAttachedFilteredEntities(userId, guid, "guid", "Glossary", "TermAnchor", "1d43d661-bdc7-4a91-a996-3239b8f82e56", 2, specificMatchPropertyNames, searchCriteria, requestedStartingFrom.intValue(), !exactValue, ignoreCase, pageSize.intValue(), "getTerms");
                HashSet<Term> terms = new HashSet<Term>();
                if (entities != null) {
                    for (EntityDetail entity : entities) {
                        SubjectAreaOMASAPIResponse<Term> termResponse = termHandler.getTermByGuid(userId, entity.getGUID());
                        if (termResponse.getRelatedHTTPCode() == 200) {
                            terms.add((Term)termResponse.results().get(0));
                            continue;
                        }
                        response = termResponse;
                        break;
                    }
                    if (response.getRelatedHTTPCode() == 200) {
                        response.addAllResults(terms);
                    }
                }
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategories(String userId, String guid, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Boolean onlyTop, SubjectAreaCategoryHandler categoryHandler) {
        SubjectAreaOMASAPIResponse<Glossary> thisGlossaryResponse;
        String methodName = "getCategories";
        if (log.isDebugEnabled()) {
            String searchCriteria = "not set";
            int startingFrom = 0;
            if (findRequest != null) {
                searchCriteria = findRequest.getSearchCriteria();
                startingFrom = findRequest.getStartingFrom();
            }
            log.debug("==> getCategories,userId=" + userId + ",guid=" + guid + ",searchCriteria=" + searchCriteria + ",startingFrom=" + startingFrom);
        }
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        Integer pageSize = findRequest.getPageSize();
        Integer requestedStartingFrom = findRequest.getStartingFrom();
        String searchCriteria = findRequest.getSearchCriteria();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (requestedStartingFrom == null) {
            requestedStartingFrom = 0;
        }
        if ((thisGlossaryResponse = this.getGlossaryByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("getCategories: got glossary guid " + guid);
                }
                HashSet<String> specificMatchPropertyNames = new HashSet<String>();
                specificMatchPropertyNames.add("displayName");
                specificMatchPropertyNames.add("description");
                specificMatchPropertyNames.add("qualifiedName");
                String parentToCheckTypeGUID = null;
                String parentToCheckTypeName = null;
                if (onlyTop.booleanValue()) {
                    parentToCheckTypeGUID = "71e4b6fb-3412-4193-aff3-a16eccd87e8e";
                    parentToCheckTypeName = "CategoryHierarchyLink";
                    if (log.isDebugEnabled()) {
                        log.debug("parentToCheckTypeGUID=" + parentToCheckTypeGUID + ",parentToCheckTypeName=" + parentToCheckTypeName);
                    }
                }
                List entities = this.genericHandler.getAttachedFilteredEntities(userId, guid, "guid", "Glossary", "CategoryAnchor", "c628938e-815e-47db-8d1c-59bb2e84e028", 2, parentToCheckTypeName, parentToCheckTypeGUID, true, specificMatchPropertyNames, searchCriteria, requestedStartingFrom.intValue(), !exactValue, ignoreCase, pageSize.intValue(), false, false, null, "getCategories");
                HashSet<Category> categories = new HashSet<Category>();
                if (entities != null) {
                    for (EntityDetail entity : entities) {
                        SubjectAreaOMASAPIResponse<Category> categoryResponse = categoryHandler.getCategoryByGuid(userId, entity.getGUID());
                        if (categoryResponse.getRelatedHTTPCode() == 200) {
                            categories.add((Category)categoryResponse.results().get(0));
                            continue;
                        }
                        response = categoryResponse;
                        break;
                    }
                    if (response.getRelatedHTTPCode() == 200) {
                        response.addAllResults(categories);
                    }
                }
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, this.className);
            }
        }
        return response;
    }
}

