/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceClassifications;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;

public class SubjectAreaTermHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaTermHandler.class.getName();
    private final TermAnchorMapper termAnchorMapper;
    private final TermCategorizationMapper termCategorizationMapper;
    private final CategoryMapper categoryMapper;

    public SubjectAreaTermHandler(OpenMetadataAPIGenericHandler genericHandler, int maxPageSize) {
        super(genericHandler, maxPageSize);
        this.termAnchorMapper = this.mappersFactory.get(TermAnchorMapper.class);
        this.termCategorizationMapper = this.mappersFactory.get(TermCategorizationMapper.class);
        this.categoryMapper = this.mappersFactory.get(CategoryMapper.class);
    }

    public SubjectAreaOMASAPIResponse<Term> createTerm(String userId, SubjectAreaRelationshipHandler relationshipHandler, Term suppliedTerm) {
        String methodName = "createTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        String createdTermGuid = null;
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
            String suppliedTermName = suppliedTerm.getName();
            if (suppliedTermName == null || suppliedTermName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createTerm", "Name", null);
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedTerm);
            TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
            EntityDetail termEntityDetail = termMapper.map(suppliedTerm);
            GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
            List suppliedCategorysummaries = suppliedTerm.getCategories();
            String glossaryGuid = this.validateGlossarySummaryDuringCreation(userId, "createTerm", suppliedGlossary);
            this.validateCategoriesDuringCreation(userId, "createTerm", suppliedCategorysummaries);
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (suppliedTerm.getEffectiveFromTime() != null) {
                effectiveFrom = new Date(suppliedTerm.getEffectiveFromTime());
            }
            if (suppliedTerm.getEffectiveToTime() != null) {
                effectiveTo = new Date(suppliedTerm.getEffectiveToTime());
            }
            GlossaryTermBuilder builder = new GlossaryTermBuilder(suppliedTerm.getQualifiedName(), suppliedTerm.getName(), suppliedTerm.getSummary(), suppliedTerm.getDescription(), suppliedTerm.getExamples(), suppliedTerm.getAbbreviation(), suppliedTerm.getUsage(), suppliedTerm.getAdditionalProperties(), suppliedTerm.getExtendedProperties(), null, this.genericHandler.getRepositoryHelper(), this.genericHandler.getServiceName(), this.genericHandler.getServerName());
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            builder.setAnchors(userId, glossaryGuid, "createTerm");
            createdTermGuid = this.genericHandler.createBeanInRepository(userId, null, null, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", null, null, (OpenMetadataAPIGenericBuilder)builder, null, "createTerm");
            if (createdTermGuid != null) {
                EntityDetail entityDetail;
                List classifications;
                TermAnchor termAnchor = new TermAnchor();
                termAnchor.getEnd1().setNodeGuid(glossaryGuid);
                termAnchor.getEnd2().setNodeGuid(createdTermGuid);
                relationshipHandler.createRelationship("createTerm", userId, TermAnchorMapper.class, termAnchor);
                response = this.getTermByGuid(userId, createdTermGuid);
                if (response.getRelatedHTTPCode() == 200 && suppliedCategorysummaries != null && suppliedCategorysummaries.size() > 0) {
                    for (CategorySummary categorySummary : suppliedCategorysummaries) {
                        Categorization categorization = new Categorization();
                        categorization.getEnd1().setNodeGuid(categorySummary.getGuid());
                        categorization.getEnd2().setNodeGuid(createdTermGuid);
                        categorization.setEffectiveFromTime(suppliedTerm.getEffectiveFromTime());
                        categorization.setEffectiveToTime(suppliedTerm.getEffectiveToTime());
                        relationshipHandler.createRelationship("createTerm", userId, TermCategorizationMapper.class, categorization);
                        if (response.getRelatedHTTPCode() == 200) continue;
                        break;
                    }
                }
                if ((classifications = (entityDetail = termMapper.map(suppliedTerm)).getClassifications()) != null) {
                    for (Classification classification : classifications) {
                        String classificationTypeName = classification.getName();
                        TypeDef typeDef = this.genericHandler.getRepositoryHelper().getTypeDefByName("createTerm", classificationTypeName);
                        if (typeDef == null) continue;
                        this.genericHandler.setClassificationInRepository(userId, null, null, createdTermGuid, "guid", "GlossaryTerm", typeDef.getGUID(), classificationTypeName, classification.getProperties(), true, false, false, null, "createTerm");
                    }
                }
                response = this.getTermByGuid(userId, createdTermGuid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            if (createdTermGuid != null) {
                this.deleteTerm(userId, createdTermGuid);
            }
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    protected void validateCategoriesDuringCreation(String userId, String methodName, List<CategorySummary> suppliedCategories) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        if (suppliedCategories != null) {
            for (CategorySummary categorySummary : suppliedCategories) {
                String guid = categorySummary.getGuid();
                this.genericHandler.getEntityFromRepository(userId, guid, "guid", "GlossaryCategory", null, null, false, false, null, methodName);
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Term> getTermByGuid(String userId, String guid) {
        String methodName = "getTermByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, guid, "guid", "GlossaryTerm", null, null, false, false, null, "getTermByGuid");
            TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
            Term term = termMapper.map(entityDetail);
            this.setSummaryObjects(userId, term, "getTermByGuid");
            response.addResult((Object)term);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> findTerm(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        SubjectAreaOMASAPIResponse response;
        block4: {
            String methodName = "findTerm";
            response = new SubjectAreaOMASAPIResponse();
            try {
                List foundTerms = this.findNodes(userId, "GlossaryTerm", "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", findRequest, exactValue, ignoreCase, TermMapper.class, "findTerm");
                if (foundTerms != null) {
                    for (Term term : foundTerms) {
                        this.setSummaryObjects(userId, term, "findTerm");
                        response.addResult((Object)term);
                    }
                    break block4;
                }
                return response;
            }
            catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    private void setSummaryObjects(String userId, Term term, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        List<Relationship> termCategorizationRelationships;
        String guid = term.getSystemAttributes().getGUID();
        List<Relationship> termAnchorRelationships = this.getRelationshipsForEntityByType(methodName, userId, guid, new FindRequest(), "GlossaryTerm", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", "Glossary");
        if (CollectionUtils.isNotEmpty(termAnchorRelationships)) {
            for (Relationship relationship : termAnchorRelationships) {
                TermAnchor termAnchor = (TermAnchor)relationship;
                GlossarySummary glossarySummary = this.getGlossarySummary(methodName, userId, (Relationship)termAnchor);
                if (glossarySummary == null) continue;
                term.setGlossary(glossarySummary);
            }
        }
        if (CollectionUtils.isNotEmpty(termCategorizationRelationships = this.getRelationshipsForEntityByType(methodName, userId, guid, new FindRequest(), "GlossaryTerm", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", "GlossaryCategory"))) {
            ArrayList<CategorySummary> categorySummaryList = new ArrayList<CategorySummary>();
            for (Relationship relationship : termCategorizationRelationships) {
                CategorySummary categorySummary;
                Categorization categorization = (Categorization)relationship;
                if (categorization == null || (categorySummary = this.getCategorySummary(methodName, userId, (Relationship)categorization)) == null) continue;
                categorySummaryList.add(categorySummary);
            }
            if (categorySummaryList.size() > 0) {
                term.setCategories(categorySummaryList);
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Relationship> getTermRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getTermRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest, "GlossaryTerm");
    }

    public SubjectAreaOMASAPIResponse<Term> updateTerm(String userId, String guid, Term suppliedTerm, SubjectAreaRelationshipHandler relationshipHandler, boolean isReplace) {
        String methodName = "updateTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term, NodeType.Activity});
            response = this.getTermByGuid(userId, guid);
            if (response.head().isPresent()) {
                List suppliedCategories;
                Term storedTerm = (Term)response.head().get();
                TermMapper termMapper = this.mappersFactory.get(TermMapper.class);
                EntityDetail suppliedEntity = termMapper.map(suppliedTerm);
                EntityDetail storedEntity = termMapper.map(storedTerm);
                Date effectiveFrom = null;
                if (suppliedTerm.getEffectiveFromTime() != null) {
                    effectiveFrom = new Date(suppliedTerm.getEffectiveFromTime());
                }
                this.genericHandler.updateBeanInRepository(userId, null, null, guid, "guid", "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", false, false, suppliedEntity.getProperties(), !isReplace, null, "updateTerm");
                Set<String> storedClassificationNames = this.getStoredClassificationNames(storedTerm);
                List suppliedClassifications = suppliedEntity.getClassifications();
                List storedClassifications = storedEntity.getClassifications();
                HashMap<String, Classification> storedClassificationMap = null;
                if (storedClassifications != null && !storedClassifications.isEmpty()) {
                    storedClassificationMap = new HashMap<String, Classification>();
                    for (Classification storedClassification : storedClassifications) {
                        if (storedClassification == null) continue;
                        storedClassificationMap.put(storedClassification.getName(), storedClassification);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)suppliedClassifications)) {
                    for (Classification suppliedClassification : suppliedClassifications) {
                        if (suppliedClassification == null) continue;
                        String classificationTypeName = suppliedClassification.getName();
                        String classificationTypeGUID = null;
                        TypeDef typeDef = this.genericHandler.getRepositoryHelper().getTypeDefByName(this.genericHandler.getServiceName(), classificationTypeName);
                        if (typeDef != null) {
                            classificationTypeGUID = typeDef.getGUID();
                        }
                        boolean isMergeUpdate = storedClassificationMap != null && storedClassificationMap.containsKey(classificationTypeName);
                        this.genericHandler.setClassificationInRepository(userId, null, null, guid, "guid", "GlossaryTerm", classificationTypeGUID, classificationTypeName, suppliedClassification.getProperties(), isMergeUpdate, false, false, null, "updateTerm");
                        storedClassificationNames.remove(suppliedClassification.getName());
                    }
                    for (String deClassifyName : storedClassificationNames) {
                        String classificationTypeGUID = null;
                        TypeDef typeDef = this.genericHandler.getRepositoryHelper().getTypeDefByName(this.genericHandler.getServiceName(), deClassifyName);
                        if (typeDef != null) {
                            classificationTypeGUID = typeDef.getGUID();
                        }
                        this.genericHandler.removeClassificationFromRepository(userId, null, null, guid, "guid", "GlossaryTerm", classificationTypeGUID, deClassifyName, false, false, null, "updateTerm");
                    }
                }
                if ((suppliedCategories = suppliedTerm.getCategories()) != null || isReplace) {
                    this.replaceCategories(userId, guid, suppliedTerm, relationshipHandler, "updateTerm");
                }
                response = this.getTermByGuid(userId, guid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response = new SubjectAreaOMASAPIResponse();
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void replaceCategories(String userId, String guid, Term suppliedTerm, SubjectAreaRelationshipHandler relationshipHandler, String methodName) throws UserNotAuthorizedException, PropertyServerException, SubjectAreaCheckedException, InvalidParameterException {
        List suppliedCategories;
        HashSet<String> deleteCategorizationGuidSet = new HashSet<String>();
        SubjectAreaOMASAPIResponse<Relationship> relationshipResponse = this.getTermRelationships(userId, guid, new FindRequest());
        List relationships = relationshipResponse.results();
        for (Relationship relationship : relationships) {
            if (!relationship.getRelationshipType().equals((Object)RelationshipType.TermCategorization)) continue;
            deleteCategorizationGuidSet.add(relationship.getGuid());
        }
        if (deleteCategorizationGuidSet != null && deleteCategorizationGuidSet.size() > 0) {
            for (String guidToDelete : deleteCategorizationGuidSet) {
                relationshipHandler.deleteRelationship(methodName, userId, TermCategorizationMapper.class, guidToDelete);
            }
        }
        if ((suppliedCategories = suppliedTerm.getCategories()) != null && suppliedCategories.size() > 0) {
            for (CategorySummary categorySummary : suppliedCategories) {
                this.addCategorizationRelationship(userId, suppliedTerm, methodName, categorySummary.getGuid());
            }
        }
    }

    private void addCategorizationRelationship(String userId, Term suppliedTerm, String methodName, String categoryGuid) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        this.genericHandler.linkElementToElement(userId, null, null, categoryGuid, "guid end1", "GlossaryCategory", suppliedTerm.getSystemAttributes().getGUID(), "guid end2", "GlossaryTerm", false, false, "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", "TermCategorization", (InstanceProperties)null, null, null, null, methodName);
    }

    private Set<String> getStoredClassificationNames(Term currentTerm) {
        Set<String> currentClassificationNames = currentTerm.getClassifications().stream().map(x -> x.getClassificationName()).collect(Collectors.toSet());
        GovernanceClassifications currentActions = currentTerm.getGovernanceClassifications();
        if (currentActions != null) {
            if (currentActions.getConfidence() != null) {
                currentClassificationNames.add(currentActions.getConfidence().getClassificationName());
            }
            if (currentActions.getConfidentiality() != null) {
                currentClassificationNames.add(currentActions.getConfidentiality().getClassificationName());
            }
            if (currentActions.getRetention() != null) {
                currentClassificationNames.add(currentActions.getRetention().getClassificationName());
            }
            if (currentActions.getCriticality() != null) {
                currentClassificationNames.add(currentActions.getCriticality().getClassificationName());
            }
        }
        return currentClassificationNames;
    }

    public SubjectAreaOMASAPIResponse<Term> deleteTerm(String userId, String guid) {
        String methodName = "deleteTerm";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            this.genericHandler.deleteBeanInRepository(userId, null, null, guid, "guid", "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", null, null, false, false, null, "deleteTerm");
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> restoreTerm(String userId, String guid) {
        String methodName = "restoreTerm";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        try {
            this.genericHandler.getRepositoryHandler().restoreEntity(userId, null, null, guid, "restoreTerm");
            response = this.getTermByGuid(userId, guid);
        }
        catch (PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getTermCategories(String userId, String guid, SubjectAreaCategoryHandler categoryHandler, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse<Term> thisTermResponse;
        String methodName = "getTermCategories";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if ((thisTermResponse = this.getTermByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            try {
                HashSet<String> specificMatchPropertyNames = new HashSet<String>();
                specificMatchPropertyNames.add("displayName");
                specificMatchPropertyNames.add("description");
                specificMatchPropertyNames.add("qualifiedName");
                List entities = this.genericHandler.getAttachedFilteredEntities(userId, guid, "guid", "GlossaryTerm", "TermCategorization", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", 1, specificMatchPropertyNames, "", startingFrom.intValue(), false, false, pageSize.intValue(), null, "getTermCategories");
                if (entities != null) {
                    HashSet<Category> categories = new HashSet<Category>();
                    for (EntityDetail entity : entities) {
                        SubjectAreaOMASAPIResponse<Category> categoryResponse = categoryHandler.getCategoryByGuid(userId, entity.getGUID());
                        if (categoryResponse.getRelatedHTTPCode() == 200) {
                            categories.add((Category)categoryResponse.results().get(0));
                            continue;
                        }
                        response = categoryResponse;
                        break;
                    }
                    if (response.getRelatedHTTPCode() == 200) {
                        response.addAllResults(categories);
                    }
                }
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }
}

