/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipEnd;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.IRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph.NodeTypeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class RelationshipMapper<R extends Relationship>
implements IRelationshipMapper<R> {
    protected final OpenMetadataAPIGenericHandler genericHandler;
    protected final OMRSRepositoryHelper repositoryHelper;

    public RelationshipMapper(OpenMetadataAPIGenericHandler genericHandler) {
        this.genericHandler = genericHandler;
        this.repositoryHelper = genericHandler.getRepositoryHelper();
    }

    @Override
    public R map(org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship omrsRelationship) {
        InstanceProperties relationshipProperties;
        EntityProxy proxy2;
        R omasRelationship = this.getRelationshipInstance();
        omasRelationship.setSystemAttributes(SubjectAreaUtils.createSystemAttributes((InstanceHeader)omrsRelationship));
        EntityProxy proxy1 = omrsRelationship.getEntityOneProxy();
        if (proxy1 != null) {
            Map map;
            PrimitivePropertyValue qualifiedNamePropertyValue;
            RelationshipEnd end1 = omasRelationship.getEnd1();
            String guid1 = proxy1.getGUID();
            if (guid1 != null) {
                end1.setNodeGuid(guid1);
            }
            if ((qualifiedNamePropertyValue = (PrimitivePropertyValue)(map = proxy1.getUniqueProperties().getInstanceProperties()).get("qualifiedName")) != null) {
                end1.setNodeQualifiedName(qualifiedNamePropertyValue.getPrimitiveValue().toString());
            }
        }
        if ((proxy2 = omrsRelationship.getEntityTwoProxy()) != null) {
            Map map;
            PrimitivePropertyValue qualifiedNamePropertyValue;
            RelationshipEnd end2 = omasRelationship.getEnd2();
            String guid2 = proxy2.getGUID();
            if (guid2 != null) {
                end2.setNodeGuid(guid2);
            }
            if ((qualifiedNamePropertyValue = (PrimitivePropertyValue)(map = proxy2.getUniqueProperties().getInstanceProperties()).get("qualifiedName")) != null) {
                end2.setNodeQualifiedName(qualifiedNamePropertyValue.getPrimitiveValue().toString());
            }
        }
        if (omrsRelationship.getInstanceProvenanceType() != InstanceProvenanceType.LOCAL_COHORT) {
            omasRelationship.setReadOnly(true);
        }
        if ((relationshipProperties = omrsRelationship.getProperties()) != null) {
            this.mapRelationshipEffectivityToInstanceProperties(omasRelationship, relationshipProperties);
            Iterator omrsPropertyIterator = relationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String propertyName = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = relationshipProperties.getPropertyValue(propertyName);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (this.mapPrimitiveToRelationship(omasRelationship, propertyName, actualValue)) break;
                        if (null == omasRelationship.getAdditionalProperties()) {
                            omasRelationship.setAdditionalProperties(new HashMap());
                        }
                        omasRelationship.getAdditionalProperties().put(propertyName, actualValue.toString());
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        if (this.mapEnumToRelationship(omasRelationship, propertyName, enumPropertyValue)) break;
                        if (null == omasRelationship.getAdditionalProperties()) {
                            omasRelationship.setAdditionalProperties(new HashMap());
                        }
                        omasRelationship.getAdditionalProperties().put(propertyName, enumPropertyValue.valueAsString());
                        break;
                    }
                    case MAP: {
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                        if (this.mapMapToRelationship(omasRelationship, propertyName, instancePropertyForMap)) break;
                        if (null == omasRelationship.getAdditionalProperties()) {
                            omasRelationship.setAdditionalProperties(new HashMap());
                        }
                        omasRelationship.getAdditionalProperties().put(propertyName, mapPropertyValue.valueAsString());
                        break;
                    }
                }
            }
        }
        return omasRelationship;
    }

    protected void mapInstancePropertiesToRelationship(R relationship, InstanceProperties instanceProperties) {
    }

    private void mapRelationshipEffectivityToInstanceProperties(R relationship, InstanceProperties instanceProperties) {
        Long fromTime = relationship.getEffectiveFromTime();
        Long toTime = relationship.getEffectiveToTime();
        if (fromTime != null) {
            instanceProperties.setEffectiveFromTime(new Date(fromTime));
        }
        if (toTime != null) {
            instanceProperties.setEffectiveToTime(new Date(toTime));
        }
    }

    @Override
    public org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship map(R omasRelationship) throws InvalidParameterException {
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship omrsRelationship = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship();
        InstanceProperties instanceProperties = new InstanceProperties();
        omrsRelationship.setProperties(instanceProperties);
        this.mapRelationshipToInstanceProperties(omasRelationship, instanceProperties);
        String proxy1Guid = omasRelationship.getEnd1().getNodeGuid();
        String proxy1NodeTypeName = omasRelationship.getEnd1().getNodeTypeName();
        String proxy1TypeName = NodeTypeMapper.mapNodeTypeNameToEntityTypeName(proxy1NodeTypeName);
        InstanceType typeEnd1 = new InstanceType();
        typeEnd1.setTypeDefName(proxy1TypeName);
        String proxy1TypeGuid = new InvalidParameterHandler().validateTypeName(proxy1TypeName, proxy1TypeName, this.genericHandler.getServiceName(), "map end1 " + omasRelationship.getRelationshipType(), this.genericHandler.getRepositoryHelper());
        typeEnd1.setTypeDefGUID(proxy1TypeGuid);
        String proxy2Guid = omasRelationship.getEnd2().getNodeGuid();
        String proxy2NodeTypeName = omasRelationship.getEnd2().getNodeTypeName();
        String proxy2TypeName = NodeTypeMapper.mapNodeTypeNameToEntityTypeName(proxy2NodeTypeName);
        String proxy2TypeGuid = new InvalidParameterHandler().validateTypeName(proxy2TypeName, proxy2TypeName, this.genericHandler.getServiceName(), "map end2 " + omasRelationship.getRelationshipType(), this.genericHandler.getRepositoryHelper());
        InstanceType typeEnd2 = new InstanceType();
        typeEnd2.setTypeDefName(proxy2TypeName);
        typeEnd2.setTypeDefGUID(proxy2TypeGuid);
        EntityProxy proxy1 = new EntityProxy();
        proxy1.setGUID(proxy1Guid);
        omrsRelationship.setEntityOneProxy(proxy1);
        EntityProxy proxy2 = new EntityProxy();
        proxy2.setGUID(proxy2Guid);
        omrsRelationship.setEntityTwoProxy(proxy2);
        String typeName = this.getTypeName();
        TypeDef typedef = this.repositoryHelper.getTypeDefByName(this.genericHandler.getServiceName(), typeName);
        InstanceType type = new InstanceType();
        type.setTypeDefName(typedef.getName());
        type.setTypeDefGUID(typedef.getGUID());
        omrsRelationship.setType(type);
        if (omasRelationship.getSystemAttributes() != null) {
            SubjectAreaUtils.populateSystemAttributesForInstanceAuditHeader(omasRelationship.getSystemAttributes(), (InstanceAuditHeader)omrsRelationship);
            omrsRelationship.setGUID(omasRelationship.getSystemAttributes().getGUID());
        }
        return omrsRelationship;
    }

    @Override
    public abstract String getTypeName();

    abstract R getRelationshipInstance();

    @Override
    public String getTypeDefGuid() {
        String guid = null;
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.genericHandler.getServiceName(), this.getTypeName());
        if (typeDef != null) {
            guid = typeDef.getGUID();
        }
        return guid;
    }

    protected boolean mapPrimitiveToRelationship(R relationship, String propertyName, Object value) {
        return false;
    }

    protected boolean mapEnumToRelationship(R relationship, String propertyName, EnumPropertyValue enumPropertyValue) {
        return false;
    }

    protected boolean mapMapToRelationship(R omasRelationship, String propertyName, InstanceProperties instancePropertyForMap) {
        return false;
    }

    protected void mapRelationshipToInstanceProperties(R omasRelationship, InstanceProperties instanceProperties) {
    }
}

