/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.SubjectAreaMapper;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.reflections.Reflections;

public class MappersFactory {
    private final Map<Class<?>, Supplier<Object>> mappers = new HashMap();
    private static final String SUBJECT_AREA_PACKAGE = "org.odpi.openmetadata.accessservices.subjectarea";

    public MappersFactory(OpenMetadataAPIGenericHandler genericHandler, String ... packagesToScan) {
        HashSet<String> packages = new HashSet<String>(Arrays.asList(packagesToScan));
        packages.add(SUBJECT_AREA_PACKAGE);
        Reflections reflections = new Reflections(new Object[]{packages});
        Set mappersClasses = reflections.getTypesAnnotatedWith(SubjectAreaMapper.class);
        for (Class mapperClass : mappersClasses) {
            try {
                Constructor ctor = mapperClass.getDeclaredConstructor(OpenMetadataAPIGenericHandler.class);
                ctor.setAccessible(true);
                Object mapper = ctor.newInstance(genericHandler);
                this.mappers.put(mapperClass, () -> mapper);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExceptionInInitializerError("During initialization MappersFactory an error has occurred - " + e.getMessage());
            }
        }
    }

    public MappersFactory(OpenMetadataAPIGenericHandler genericHandler) {
        this(genericHandler, SUBJECT_AREA_PACKAGE);
    }

    public <T> T get(Class<T> mapperClass) {
        if (this.mappers.containsKey(mapperClass)) {
            return (T)this.mappers.get(mapperClass).get();
        }
        return null;
    }

    public Set<Class<?>> getAllMapperClasses() {
        return this.mappers.keySet();
    }
}

