/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.CanonicalVocabulary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ClassificationMapper;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanonicalVocabularyMapper
extends ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(CanonicalVocabularyMapper.class);
    private static final String className = CanonicalVocabularyMapper.class.getName();
    private static final String typeName = "CanonicalVocabulary";

    public CanonicalVocabularyMapper(OpenMetadataAPIGenericHandler genericHandler) {
        super(genericHandler);
    }

    @Override
    protected Set<String> mapKnownAttributesToOmrs(Classification omasClassification, InstanceProperties omrsClassificationProperties) {
        CanonicalVocabulary canonicalVocabulary = (CanonicalVocabulary)omasClassification;
        String stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "scope", omrsClassificationProperties, "");
        canonicalVocabulary.setScope(stringValue);
        return CanonicalVocabulary.getPropertyNames();
    }

    @Override
    protected Classification createOmasClassification() {
        return new CanonicalVocabulary();
    }

    @Override
    protected String getTypeName() {
        return typeName;
    }

    @Override
    protected InstanceProperties updateOMRSAttributes(Classification omasClassification) {
        InstanceProperties instanceProperties = new InstanceProperties();
        CanonicalVocabulary canonicalVocabulary = (CanonicalVocabulary)omasClassification;
        if (canonicalVocabulary.getScope() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "scope", canonicalVocabulary.getScope(), "updateOMRSAttributes");
        }
        return instanceProperties;
    }
}

