/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaConfigHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.slf4j.LoggerFactory;

public class SubjectAreaConfigRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();
    private static final String className = SubjectAreaConfigRESTServices.class.getName();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SubjectAreaConfigRESTServices.class), instanceHandler.getServiceName());

    public SubjectAreaOMASAPIResponse<Config> getConfig(String serverName, String userId) {
        String methodName = "getConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfig");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfig");
            SubjectAreaConfigHandler handler = instanceHandler.getSubjectAreaConfigHandler(userId, serverName, "getConfig");
            response = handler.getConfig(userId);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getConfig");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

