/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();
    private static final String className = SubjectAreaGlossaryRESTServices.class.getName();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SubjectAreaGlossaryRESTServices.class), instanceHandler.getServiceName());

    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(String serverName, String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "createGlossary");
            response = handler.createGlossary(userId, suppliedGlossary);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "createGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> getGlossaryByGuid(String serverName, String userId, String guid) {
        String methodName = "getGlossaryByGuid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryByGuid");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryByGuid");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "getGlossaryByGuid");
            response = handler.getGlossaryByGuid(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGlossaryByGuid");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(String serverName, String userId, String searchCriteria, boolean exactValue, boolean ignoreCase, Date asOfTime, Integer startingFrom, Integer pageSize, String sequencingOrder, String sequencingProperty) {
        String methodName = "findGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossary");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossary");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "findGlossary");
            FindRequest findRequest = this.getFindRequest(searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty, handler.getMaxPageSize());
            response = handler.findGlossary(userId, findRequest, exactValue, ignoreCase);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "findGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getGlossaryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, methodName);
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            response = handler.getGlossaryRelationships(userId, guid, findRequest);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, methodName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(String serverName, String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "updateGlossary");
            response = handler.updateGlossary(userId, guid, suppliedGlossary, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "updateGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(String serverName, String userId, String guid) {
        String methodName = "deleteGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGlossary");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGlossary");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "deleteGlossary");
            response = handler.deleteGlossary(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "deleteGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(String serverName, String userId, String guid) {
        String methodName = "restoreGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreGlossary");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreGlossary");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "restoreGlossary");
            response = handler.restoreGlossary(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "restoreGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getGlossaryTerms(String serverName, String userId, String guid, String searchCriteria, boolean exactValue, boolean ignoreCase, Date asOfTime, Integer startingFrom, Integer pageSize, String sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTerms");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTerms");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "getGlossaryTerms");
            FindRequest findRequest = this.getFindRequest(searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty, handler.getMaxPageSize());
            response = handler.getTerms(userId, guid, instanceHandler.getSubjectAreaTermHandler(userId, serverName, "getGlossaryTerms"), findRequest, exactValue, ignoreCase);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGlossaryTerms");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getGlossaryCategories(String serverName, String userId, String guid, String searchCriteria, boolean exactValue, boolean ignoreCase, Date asOfTime, Boolean onlyTop, Integer startingFrom, Integer pageSize, String sequencingOrder, String sequencingProperty) {
        String methodName = "getCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategories");
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategories");
            SubjectAreaGlossaryHandler handler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "getCategories");
            FindRequest findRequest = this.getFindRequest(searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty, handler.getMaxPageSize());
            response = handler.getCategories(userId, guid, findRequest, exactValue, ignoreCase, onlyTop, instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "getCategories"));
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getCategories");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

