/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;

public class NodeTypeMapper {
    public static String mapNodeTypeToEntityTypeGuid(NodeType nodeType) {
        String entityTypeName = nodeType.name();
        if (nodeType.name().equals("Term") || nodeType.name().equals("Activity")) {
            entityTypeName = "GlossaryTerm";
        } else if (nodeType.name().equals("Category") || nodeType.name().equals("SubjectAreaDefinition")) {
            entityTypeName = "GlossaryCategory";
        } else if (nodeType.name().equals("Taxonomy") || nodeType.name().equals("CanonicalGlossary") || nodeType.name().equals("TaxonomyAndCanonicalGlossary")) {
            entityTypeName = "Glossary";
        } else if (nodeType.name().equals("GlossaryProject")) {
            entityTypeName = "Project";
        }
        return OpenMetadataTypesArchiveAccessor.getInstance().getEntityDefByName(entityTypeName).getGUID();
    }

    public static String mapNodeTypeNameToEntityTypeName(String nodeTypeName) {
        String entityTypeName = nodeTypeName;
        if (nodeTypeName.equals("Term") || nodeTypeName.equals("Activity")) {
            entityTypeName = "GlossaryTerm";
        } else if (nodeTypeName.equals("Category") || nodeTypeName.equals("SubjectAreaDefinition")) {
            entityTypeName = "GlossaryCategory";
        } else if (nodeTypeName.equals("Taxonomy") || nodeTypeName.equals("CanonicalGlossary") || nodeTypeName.equals("TaxonomyAndCanonicalGlossary")) {
            entityTypeName = "Glossary";
        } else if (nodeTypeName.equals("GlossaryProject")) {
            entityTypeName = "Project";
        }
        return entityTypeName;
    }
}

