/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryHierarchyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class SubjectAreaCategoryHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaCategoryHandler.class.getName();

    public SubjectAreaCategoryHandler(OpenMetadataAPIGenericHandler genericHandler, int maxPageSize) {
        super(genericHandler, maxPageSize);
    }

    public SubjectAreaOMASAPIResponse<Category> createCategory(String userId, SubjectAreaRelationshipHandler relationshipHandler, Category suppliedCategory) {
        String methodName = "createCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        String createdCategoryGuid = null;
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            String suppliedCategoryName = suppliedCategory.getName();
            if (suppliedCategoryName == null || suppliedCategoryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createCategory", "Name", null);
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedCategory);
            GlossarySummary suppliedGlossary = suppliedCategory.getGlossary();
            String glossaryGuid = this.validateGlossarySummaryDuringCreation(userId, "createCategory", suppliedGlossary);
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (suppliedCategory.getEffectiveFromTime() != null) {
                effectiveFrom = new Date(suppliedCategory.getEffectiveFromTime());
            }
            if (suppliedCategory.getEffectiveToTime() != null) {
                effectiveTo = new Date(suppliedCategory.getEffectiveToTime());
            }
            GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(suppliedCategory.getQualifiedName(), suppliedCategory.getName(), suppliedCategory.getDescription(), this.genericHandler.getRepositoryHelper(), this.genericHandler.getServiceName(), this.genericHandler.getServerName());
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            builder.setAnchors(userId, glossaryGuid, "createCategory");
            createdCategoryGuid = this.genericHandler.createBeanInRepository(userId, null, null, "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", null, null, (OpenMetadataAPIGenericBuilder)builder, "createCategory");
            if (response.getRelatedHTTPCode() == 200) {
                CategoryAnchor categoryAnchor = new CategoryAnchor();
                categoryAnchor.getEnd1().setNodeGuid(glossaryGuid);
                categoryAnchor.getEnd2().setNodeGuid(createdCategoryGuid);
                SubjectAreaOMASAPIResponse<CategoryAnchor> categoryAnchorResponse = relationshipHandler.createRelationship("createCategory", userId, CategoryAnchorMapper.class, categoryAnchor);
                if (categoryAnchorResponse.getRelatedHTTPCode() == 200) {
                    CategoryAnchor createdCategoryAnchor = (CategoryAnchor)categoryAnchorResponse.results().get(0);
                    createdCategoryAnchor.getGuid();
                    if (suppliedCategory.getNodeType() == NodeType.SubjectAreaDefinition) {
                        this.genericHandler.setClassificationInRepository(userId, createdCategoryGuid, "guid", "GlossaryCategory", "480e6993-35c5-433a-b50b-0f5c4063fb5d", "SubjectArea", null, "createCategory");
                    }
                    if (suppliedCategory.getParentCategory() != null && suppliedCategory.getParentCategory().getGuid() != null) {
                        String parentCategoryGuid = suppliedCategory.getParentCategory().getGuid();
                        CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
                        categoryHierarchyLink.getEnd1().setNodeGuid(parentCategoryGuid);
                        categoryHierarchyLink.getEnd2().setNodeGuid(createdCategoryGuid);
                        relationshipHandler.createRelationship("createCategory", userId, CategoryHierarchyLinkMapper.class, categoryHierarchyLink);
                    }
                }
                response = this.getCategoryByGuid(userId, createdCategoryGuid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            if (createdCategoryGuid != null) {
                this.deleteCategory(userId, createdCategoryGuid);
            }
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategoryByGuid(String userId, String guid) {
        String methodName = "getCategory";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, guid, "guid", "GlossaryCategory", null, null, false, false, null, "getCategory");
            CategoryMapper categoryMapper = this.mappersFactory.get(CategoryMapper.class);
            Category category = categoryMapper.map(entityDetail);
            this.populateGlossarySummaryFromOMRS(userId, category, "getCategory");
            this.populateParentCategoryFromOMRS(userId, category, "getCategory");
            response.addResult((Object)category);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> findCategory(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        String methodName = "findCategory";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundCategories = this.findNodes(userId, "GlossaryCategory", "e507485b-9b5a-44c9-8a28-6967f7ff3672", findRequest, exactValue, ignoreCase, CategoryMapper.class, "findCategory");
            if (foundCategories != null) {
                for (Category category : foundCategories) {
                    this.populateGlossarySummaryFromOMRS(userId, category, "findCategory");
                    this.populateParentCategoryFromOMRS(userId, category, "findCategory");
                    response.addResult((Object)category);
                }
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void populateGlossarySummaryFromOMRS(String userId, Category category, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String guid = category.getSystemAttributes().getGUID();
        List<Relationship> relationships = this.getRelationshipsForEntityByType(methodName, userId, guid, new FindRequest(), "GlossaryCategory", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", "Glossary");
        if (CollectionUtils.isNotEmpty(relationships)) {
            for (Relationship relationship : relationships) {
                CategoryAnchor categoryAnchor = (CategoryAnchor)relationship;
                GlossarySummary glossarySummary = this.getGlossarySummary(methodName, userId, (Relationship)categoryAnchor);
                if (glossarySummary == null) continue;
                category.setGlossary(glossarySummary);
                break;
            }
        }
    }

    private void populateParentCategoryFromOMRS(String userId, Category category, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String currentCategoryGuid = category.getSystemAttributes().getGUID();
        List foundEntities = this.genericHandler.getAttachedFilteredEntities(userId, currentCategoryGuid, "guid", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "CategoryHierarchyLink", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", 1, null, null, 0, false, false, this.maxPageSize, methodName);
        if (CollectionUtils.isNotEmpty((Collection)foundEntities)) {
            for (EntityDetail entity : foundEntities) {
                String entityGUID = entity.getGUID();
                List<Relationship> relationships = this.getRelationshipsForEntityByType(methodName, userId, entityGUID, new FindRequest(), "GlossaryCategory", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", "GlossaryCategory");
                for (Relationship relationship : relationships) {
                    String parentGuid = relationship.getEnd1().getNodeGuid();
                    String childGuid = relationship.getEnd2().getNodeGuid();
                    if (!entityGUID.equals(parentGuid) || !currentCategoryGuid.equals(childGuid)) continue;
                    CategoryMapper categoryMapper = this.mappersFactory.get(CategoryMapper.class);
                    CategoryHierarchyLink link = (CategoryHierarchyLink)relationship;
                    Category parentCategory = categoryMapper.map(entity);
                    category.setParentCategory(SubjectAreaUtils.extractCategorySummaryFromCategory(parentCategory, (Relationship)link));
                }
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Relationship> getCategoryRelationships(String userId, String guid, FindRequest findRequest) {
        String restAPIName = "getCategoryRelationships";
        return this.getAllRelationshipsForEntity(restAPIName, userId, guid, findRequest, "GlossaryCategory");
    }

    public SubjectAreaOMASAPIResponse<Category> updateCategory(String userId, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (suppliedCategory.getEffectiveFromTime() != null) {
                effectiveFrom = new Date(suppliedCategory.getEffectiveFromTime());
            }
            if (suppliedCategory.getEffectiveToTime() != null) {
                effectiveTo = new Date(suppliedCategory.getEffectiveToTime());
            }
            GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(suppliedCategory.getQualifiedName(), suppliedCategory.getName(), suppliedCategory.getDescription(), this.genericHandler.getRepositoryHelper(), this.genericHandler.getServiceName(), this.genericHandler.getServerName());
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            this.genericHandler.updateBeanInRepository(userId, null, null, guid, "guid", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", false, false, builder.getInstanceProperties("updateCategory"), !isReplace, null, "updateCategory");
            response = this.getCategoryByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> deleteCategory(String userId, String guid) {
        String methodName = "deleteCategory";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            this.genericHandler.deleteBeanInRepository(userId, null, null, guid, "guid", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", null, null, false, false, null, "deleteCategory");
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> restoreCategory(String userId, String guid) {
        String methodName = "restoreCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            this.genericHandler.getRepositoryHandler().restoreEntity(userId, null, null, guid, "restoreCategory");
            response = this.getCategoryByGuid(userId, guid);
        }
        catch (PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getCategorizedTerms(String userId, String guid, String searchCriteria, boolean exactValue, boolean ignoreCase, SubjectAreaTermHandler termHandler, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse<Category> thisCategoryResponse;
        String methodName = "getCategorizedTerms";
        SubjectAreaOMASAPIResponse<Term> response = new SubjectAreaOMASAPIResponse<Term>();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if ((thisCategoryResponse = this.getCategoryByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            try {
                HashSet<String> specificMatchPropertyNames = new HashSet<String>();
                specificMatchPropertyNames.add("displayName");
                specificMatchPropertyNames.add("description");
                specificMatchPropertyNames.add("qualifiedName");
                List entities = this.genericHandler.getAttachedFilteredEntities(userId, guid, "guid", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "TermCategorization", "696a81f5-ac60-46c7-b9fd-6979a1e7ad27", 2, specificMatchPropertyNames, searchCriteria, startingFrom.intValue(), !exactValue, ignoreCase, pageSize.intValue(), null, "getCategorizedTerms");
                HashSet<Term> terms = new HashSet<Term>();
                if (CollectionUtils.isNotEmpty((Collection)entities)) {
                    for (EntityDetail entity : entities) {
                        SubjectAreaOMASAPIResponse<Term> termResponse = termHandler.getTermByGuid(userId, entity.getGUID());
                        if (termResponse.getRelatedHTTPCode() == 200) {
                            terms.add((Term)termResponse.results().get(0));
                            continue;
                        }
                        response = termResponse;
                        break;
                    }
                    if (response.getRelatedHTTPCode() == 200) {
                        response.addAllResults(terms);
                    }
                }
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategoryChildren(String userId, String guid, String searchCriteria, boolean exactValue, boolean ignoreCase, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse<Category> thisCategoryResponse;
        String methodName = "getCategoryChildren";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if ((thisCategoryResponse = this.getCategoryByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            try {
                HashSet<String> specificMatchPropertyNames = new HashSet<String>();
                specificMatchPropertyNames.add("displayName");
                specificMatchPropertyNames.add("description");
                specificMatchPropertyNames.add("qualifiedName");
                List entities = this.genericHandler.getAttachedFilteredEntities(userId, guid, "guid", "e507485b-9b5a-44c9-8a28-6967f7ff3672", "CategoryHierarchyLink", "71e4b6fb-3412-4193-aff3-a16eccd87e8e", 2, specificMatchPropertyNames, searchCriteria, startingFrom.intValue(), !exactValue, ignoreCase, pageSize.intValue(), null, "getCategoryChildren");
                HashSet<Category> categories = new HashSet<Category>();
                if (CollectionUtils.isNotEmpty((Collection)entities)) {
                    for (EntityDetail entity : entities) {
                        SubjectAreaOMASAPIResponse<Category> categoryResponse = this.getCategoryByGuid(userId, entity.getGUID());
                        if (categoryResponse.getRelatedHTTPCode() == 200) {
                            categories.add((Category)categoryResponse.results().get(0));
                            continue;
                        }
                        response = categoryResponse;
                        break;
                    }
                    if (response.getRelatedHTTPCode() == 200) {
                        response.addAllResults(categories);
                    }
                }
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }
}

