/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.GlossaryProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubjectAreaMapper
public class ProjectMapper
extends EntityDetailMapper<Project> {
    private static final Logger log = LoggerFactory.getLogger(ProjectMapper.class);
    private static final String className = ProjectMapper.class.getName();
    public static final String PROJECT = "Project";
    public static final String GLOSSARY_PROJECT = "GlossaryProject";

    public ProjectMapper(OpenMetadataAPIGenericHandler genericHandler) {
        super(genericHandler);
    }

    @Override
    public Project map(EntityDetail entityDetail) {
        Project project = new Project();
        List omrsClassifications = entityDetail.getClassifications();
        if (omrsClassifications != null) {
            for (Classification omrsClassification : omrsClassifications) {
                if (this.repositoryHelper.isTypeOf(this.genericHandler.getServiceName(), GLOSSARY_PROJECT, omrsClassification.getName())) {
                    project = new GlossaryProject();
                    continue;
                }
                project = new Project();
            }
        }
        this.mapEntityDetailToNode(project, entityDetail);
        return project;
    }

    @Override
    public EntityDetail map(Project node) throws InvalidParameterException {
        return super.toEntityDetail(node);
    }

    @Override
    protected List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> getInlinedClassifications(Project node) {
        ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> inlinedClassifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
        if (node.getNodeType() == NodeType.GlossaryProject) {
            org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.GlossaryProject glossaryProjectClassification = new org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.GlossaryProject();
            inlinedClassifications.add((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification)glossaryProjectClassification);
        }
        return inlinedClassifications;
    }

    @Override
    protected boolean mapPrimitiveToNode(Project project, String propertyName, Object value) {
        boolean foundProperty = true;
        if (propertyName.equals("startDate")) {
            Date dateValue = (Date)value;
            project.setStartDate(dateValue);
        } else if (propertyName.equals("plannedEndDate")) {
            Date dateValue = (Date)value;
            project.setPlannedEndDate(dateValue);
        } else if (propertyName.equals("status")) {
            String stringValue = (String)value;
            project.setStatus(stringValue);
        } else {
            foundProperty = false;
        }
        return foundProperty;
    }

    @Override
    protected void mapNodeToInstanceProperties(Project project, InstanceProperties instanceProperties) {
        if (project.getStatus() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, project.getStatus(), "status");
        }
        if (project.getStartDate() != null) {
            SubjectAreaUtils.setDatePropertyInInstanceProperties(instanceProperties, project.getStartDate(), "startDate");
        }
        if (project.getPlannedEndDate() != null) {
            SubjectAreaUtils.setDatePropertyInInstanceProperties(instanceProperties, project.getPlannedEndDate(), "plannedEndDate");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Project project, org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        boolean handled = false;
        String classificationName = omasClassification.getClassificationName();
        NodeType existingNodeType = project.getNodeType();
        if (existingNodeType == null) {
            existingNodeType = NodeType.Project;
        }
        String sourceName = this.genericHandler.getServiceName();
        if (existingNodeType == NodeType.Project && this.repositoryHelper.isTypeOf(sourceName, GLOSSARY_PROJECT, classificationName)) {
            project.setNodeType(NodeType.GlossaryProject);
            handled = true;
        } else {
            project.setNodeType(existingNodeType);
            handled = true;
        }
        return handled;
    }

    @Override
    public String getTypeName() {
        return PROJECT;
    }
}

