/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.OmasObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.IRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.Mapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.MappersFactory;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class SubjectAreaHandler {
    private static final String className = SubjectAreaHandler.class.getName();
    protected final MappersFactory mappersFactory;
    protected final OpenMetadataAPIGenericHandler genericHandler;
    protected final int maxPageSize;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public SubjectAreaHandler(OpenMetadataAPIGenericHandler genericHandler, int maxPageSize) {
        this.genericHandler = genericHandler;
        this.mappersFactory = new MappersFactory(genericHandler);
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(this.maxPageSize);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    GlossarySummary getGlossarySummary(String restAPIName, String userId, Relationship relationship) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        String guid = SubjectAreaUtils.getGlossaryGuidFromAnchor(relationship);
        EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, guid, "guid", "Glossary", null, null, false, false, null, restAPIName);
        GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
        Glossary glossary = glossaryMapper.map(entityDetail);
        return SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary, relationship);
    }

    CategorySummary getCategorySummary(String restAPIName, String userId, Relationship relationship) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        String categoryGuid = relationship.getEnd1().getNodeGuid();
        EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, categoryGuid, "guid", "GlossaryCategory", null, null, false, false, null, restAPIName);
        CategoryMapper CategoryMapper2 = this.mappersFactory.get(CategoryMapper.class);
        Category category = CategoryMapper2.map(entityDetail);
        return SubjectAreaUtils.extractCategorySummaryFromCategory(category, relationship);
    }

    protected String sanitiseFindRequest(String searchCriteria, boolean exactValue, boolean ignoreCase) {
        OMRSRepositoryHelper omrsRepositoryHelper = this.genericHandler.getRepositoryHelper();
        if (searchCriteria != null && "".equals(searchCriteria.trim())) {
            searchCriteria = ".*";
        } else {
            searchCriteria = searchCriteria.trim();
            searchCriteria = exactValue ? omrsRepositoryHelper.getExactMatchRegex(searchCriteria, ignoreCase) : omrsRepositoryHelper.getStartsWithRegex(searchCriteria, ignoreCase);
        }
        return searchCriteria;
    }

    protected FindRequest sanitiseFindRequest(FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        FindRequest sanitisedFindRequest = findRequest;
        String searchCriteria = this.sanitiseFindRequest(findRequest.getSearchCriteria(), exactValue, ignoreCase);
        sanitisedFindRequest.setSearchCriteria(searchCriteria);
        return sanitisedFindRequest;
    }

    protected <T extends Node> List<T> findNodes(String userId, String typeEntityName, String typeEntityGuid, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Class<? extends INodeMapper<T>> mapperClass, String methodName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        List entityDetails = null;
        List<T> foundEntities = null;
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
        }
        this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
        if (findRequest.getSearchCriteria() == null) {
            entityDetails = this.genericHandler.getEntitiesByType(userId, typeEntityGuid, typeEntityName, findRequest.getSequencingProperty(), false, false, findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), null, methodName);
        } else {
            FindRequest sanitisedFindRequest = this.sanitiseFindRequest(findRequest, exactValue, ignoreCase);
            entityDetails = this.genericHandler.findEntities(userId, sanitisedFindRequest.getSearchCriteria(), "searchCriteria", typeEntityGuid, typeEntityName, null, null, findRequest.getSequencingProperty(), findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), null, methodName);
        }
        if (entityDetails != null) {
            foundEntities = this.convertOmrsToOmas(entityDetails, mapperClass);
        }
        return foundEntities;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getAllRelationshipsForEntity(String methodName, String userId, String guid, FindRequest findRequest, String entityTypeName) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            if (findRequest.getPageSize() == null) {
                findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
            }
            this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
            response.addAllResults(this.getAllRelationshipForEntity(methodName, userId, guid, findRequest, entityTypeName));
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public List<Relationship> getAllRelationshipForEntity(String restAPIName, String userId, String entityGuid, FindRequest findRequest, String entityTypeName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
        }
        this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), restAPIName);
        List relationships = this.genericHandler.getAttachmentLinks(userId, entityGuid, "guid", entityTypeName, null, null, null, findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), null, restAPIName);
        return this.getRelationshipsFromRelationships(relationships);
    }

    public List<Relationship> getRelationshipsForEntityByType(String restAPIName, String userId, String entityGuid, FindRequest findRequest, String entityTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(this.invalidParameterHandler.getMaxPagingSize()));
        }
        this.invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), restAPIName);
        List relationships = this.genericHandler.getAttachmentLinks(userId, entityGuid, "guid", entityTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), null, restAPIName);
        return this.getRelationshipsFromRelationships(relationships);
    }

    public List<Relationship> getRelationshipsFromRelationships(Collection<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> relationships) {
        return this.convertOmrsToOmas(relationships, IRelationshipMapper.class);
    }

    public List<Node> getNodesFromEntityDetails(Collection<EntityDetail> entityDetails) {
        return this.convertOmrsToOmas(entityDetails, INodeMapper.class);
    }

    public <R extends InstanceHeader, T extends OmasObject> List<T> convertOmrsToOmas(Collection<R> list, Class<? extends Mapper> mapperInterface) {
        ArrayList result = new ArrayList();
        if (list != null) {
            HashMap<String, Mapper> cache = new HashMap<String, Mapper>();
            for (InstanceHeader entityDetail : list) {
                String typeDefName = entityDetail.getType().getTypeDefName();
                if (cache.containsKey(typeDefName)) {
                    Mapper mapper = (Mapper)cache.get(typeDefName);
                    result.add(mapper.map(entityDetail));
                    continue;
                }
                Set<Class<?>> allMapperClasses = this.mappersFactory.getAllMapperClasses();
                for (Class<?> mapperClass : allMapperClasses) {
                    Mapper mapper;
                    if (!mapperInterface.isAssignableFrom(mapperClass) || !(mapper = mapperInterface.cast(this.mappersFactory.get(mapperClass))).getTypeName().equals(typeDefName)) continue;
                    cache.put(typeDefName, mapper);
                    result.add(mapper.map(entityDetail));
                }
            }
        }
        return result;
    }

    protected String validateGlossarySummaryDuringCreation(String userId, String methodName, GlossarySummary suppliedGlossary) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        if (suppliedGlossary != null) {
            String guid = suppliedGlossary.getGuid();
            String relationshipGuid = suppliedGlossary.getRelationshipguid();
            if (relationshipGuid != null) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
            }
            EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, guid, "guid", "Glossary", null, null, false, false, null, methodName);
            return entityDetail.getGUID();
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition(new String[]{methodName});
        throw new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
    }

    protected void setUniqueQualifiedNameIfBlank(Node node) {
        String qualifiedName = node.getQualifiedName();
        if (qualifiedName == null || qualifiedName.trim().equals("")) {
            node.setQualifiedName(node.getName() + "@" + UUID.randomUUID().toString());
        }
    }

    protected void setNodeEffectivity(String userId, Node node, String methodName, String guid, String typeGUID, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Long effectiveFromLong = node.getEffectiveFromTime();
        Long effectiveToLong = node.getEffectiveToTime();
        if (effectiveFromLong != null || effectiveToLong != null) {
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (effectiveToLong != null) {
                effectiveTo = new Date(effectiveToLong);
            }
            if (effectiveFromLong != null) {
                effectiveFrom = new Date(effectiveFromLong);
            }
            this.genericHandler.updateBeanEffectivityDates(userId, null, null, guid, "guid", typeGUID, typeName, false, false, effectiveFrom, effectiveTo, methodName);
        }
    }

    protected void setRelationshipEffectivity(String userId, Node node, String methodName, String relationshipGUID, String typeGUID, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Long effectiveFromLong = node.getEffectiveFromTime();
        Long effectiveToLong = node.getEffectiveToTime();
        if (effectiveFromLong != null || effectiveToLong != null) {
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (effectiveToLong != null) {
                effectiveTo = new Date(effectiveToLong);
            }
            if (effectiveFromLong != null) {
                effectiveFrom = new Date(effectiveFromLong);
            }
            this.genericHandler.updateRelationshipEffectivityDates(userId, null, null, relationshipGUID, "relationshipGUID", typeName, effectiveFrom, effectiveTo, methodName);
        }
    }
}

