/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.events.SubjectAreaEvent;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaPublisher {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaPublisher.class);
    private OpenMetadataTopicConnector connector = null;

    public SubjectAreaPublisher(Connection subjectAreaOutTopic, AuditLog auditLog) throws OMAGConfigurationErrorException {
        if (subjectAreaOutTopic != null) {
            this.connector = this.getTopicConnector(subjectAreaOutTopic, auditLog);
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, AuditLog auditLog) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(auditLog);
            Connector connector = connectorBroker.getConnector(topicConnection);
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connector;
            topicConnector.start();
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            log.error("Unable to create topic connector: " + error.toString());
            throw new OMAGConfigurationErrorException(SubjectAreaErrorCode.BAD_OUT_TOPIC_CONNECTION.getMessageDefinition(new String[]{topicConnection.toString(), error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private String getJSONPayload(SubjectAreaEvent event) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString((Object)event);
        }
        catch (Exception error) {
            log.error("Unable to create event payload: " + error.toString());
        }
        return jsonString;
    }
}

