/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaConfigHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaProjectHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SubjectAreaServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription myDescription = AccessServiceDescription.SUBJECT_AREA_OMAS;
    private final SubjectAreaGlossaryHandler glossaryHandler;
    private final SubjectAreaProjectHandler projectHandler;
    private final SubjectAreaTermHandler termHandler;
    private final SubjectAreaCategoryHandler categoryHandler;
    private final SubjectAreaRelationshipHandler relationshipHandler;
    private final SubjectAreaGraphHandler graphHandler;
    private final SubjectAreaConfigHandler configHandler;

    public SubjectAreaServicesInstance(OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, auditLog, localServerUserId, maxPageSize);
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(SubjectAreaErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        OpenMetadataAPIGenericHandler genericHandler = new OpenMetadataAPIGenericHandler(null, Glossary.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.glossaryHandler = new SubjectAreaGlossaryHandler(genericHandler, maxPageSize);
        this.termHandler = new SubjectAreaTermHandler(genericHandler, maxPageSize);
        this.categoryHandler = new SubjectAreaCategoryHandler(genericHandler, maxPageSize);
        this.projectHandler = new SubjectAreaProjectHandler(genericHandler, maxPageSize);
        this.graphHandler = new SubjectAreaGraphHandler(genericHandler, maxPageSize);
        this.relationshipHandler = new SubjectAreaRelationshipHandler(genericHandler, maxPageSize);
        this.configHandler = new SubjectAreaConfigHandler(genericHandler, maxPageSize);
    }

    public SubjectAreaGlossaryHandler getGlossaryHandler() {
        return this.glossaryHandler;
    }

    public SubjectAreaProjectHandler getProjectHandler() {
        return this.projectHandler;
    }

    public SubjectAreaTermHandler getTermHandler() {
        return this.termHandler;
    }

    public SubjectAreaCategoryHandler getCategoryHandler() {
        return this.categoryHandler;
    }

    public SubjectAreaRelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }

    public SubjectAreaGraphHandler getGraphHandler() {
        return this.graphHandler;
    }

    public SubjectAreaConfigHandler getConfigHandler() {
        return this.configHandler;
    }
}

