/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.CanonicalVocabularyMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ConfidenceMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ConfidentialityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.CriticalityMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.GlossaryProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ObjectIdentifierMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.RetentionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.SpineAttributeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.SpineObjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.TaxonomyMapper;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassificationFactory.class);
    private static final String className = ClassificationFactory.class.getName();
    private OMRSRepositoryHelper repositoryHelper;
    private OpenMetadataAPIGenericHandler genericHandler;

    public ClassificationFactory(OpenMetadataAPIGenericHandler genericHandler) {
        this.genericHandler = genericHandler;
        this.repositoryHelper = genericHandler.getRepositoryHelper();
    }

    public org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification getOMASClassification(String name, Classification omrsClassification) {
        String serviceName = this.genericHandler.getServiceName();
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineAttribute")) {
            return new SpineAttributeMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "CanonicalVocabulary")) {
            return new CanonicalVocabularyMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidence")) {
            return new ConfidenceMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Criticality")) {
            return new CriticalityMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "GlossaryProject")) {
            return new GlossaryProjectMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineObject")) {
            return new SpineObjectMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Taxonomy")) {
            return new TaxonomyMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Retention")) {
            return new RetentionMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SubjectArea")) {
            return new SubjectAreaMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "ObjectIdentifier")) {
            return new ObjectIdentifierMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidentiality")) {
            return new ConfidentialityMapper(this.genericHandler).mapOmrsToBean(omrsClassification);
        }
        return null;
    }

    public Classification getOMRSClassification(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        String name = omasClassification.getClassificationName();
        String serviceName = this.genericHandler.getServiceName();
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineAttribute")) {
            return new SpineAttributeMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "CanonicalVocabulary")) {
            return new CanonicalVocabularyMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidence")) {
            return new ConfidenceMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Criticality")) {
            return new CriticalityMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "GlossaryProject")) {
            return new GlossaryProjectMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SpineObject")) {
            return new SpineObjectMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Taxonomy")) {
            return new TaxonomyMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Retention")) {
            return new RetentionMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "SubjectArea")) {
            return new SubjectAreaMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "ObjectIdentifier")) {
            return new ObjectIdentifierMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        if (this.repositoryHelper.isTypeOf(serviceName, name, "Confidentiality")) {
            return new ConfidentialityMapper(this.genericHandler).mapBeanToOmrs(omasClassification);
        }
        return null;
    }
}

