/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(RelationshipTypeMapper.class);
    private static final String className = RelationshipTypeMapper.class.getName();

    public static String mapOMASRelationshipTypeToOMRSRelationshipTypeGuid(String operation, RelationshipType omasRelationshipType) throws InvalidParameterException {
        String guid = null;
        if (omasRelationshipType == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_RELATIONSHIPTYPES_FOR_GRAPH.getMessageDefinition();
            String invalidPropertyName = "relationshipFilter";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, operation, invalidPropertyName, null);
        }
        if (omasRelationshipType == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.UNKNOWN_RELATIONSHIPTYPE_REQUESTED_FOR_GRAPH.getMessageDefinition();
            String invalidPropertyName = "relationshipFilter";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, RelationshipType.Unknown.name()});
            throw new InvalidParameterException(messageDefinition, className, operation, invalidPropertyName, RelationshipType.Unknown.name());
        }
        String relationshipTypeName = omasRelationshipType.name();
        if (omasRelationshipType.equals((Object)RelationshipType.HasA)) {
            relationshipTypeName = "TermHASARelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.IsA)) {
            relationshipTypeName = "ISARelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.IsATypeOfDeprecated)) {
            relationshipTypeName = "TermISATypeOFRelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.IsATypeOf)) {
            relationshipTypeName = "IsATypeOfRelationship";
        } else if (omasRelationshipType.equals((Object)RelationshipType.TypedBy)) {
            relationshipTypeName = "TermTYPEDBYRelationship";
        }
        RelationshipDef relationshipDef = OpenMetadataTypesArchiveAccessor.getInstance().getRelationshipDefByName(relationshipTypeName);
        if (relationshipDef == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_RELATIONSHIPTYPES_FOR_GRAPH.getMessageDefinition();
            String invalidPropertyName = "relationshipFilter";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, relationshipTypeName});
            throw new InvalidParameterException(messageDefinition, className, operation, invalidPropertyName, relationshipTypeName);
        }
        guid = relationshipDef.getGUID();
        return guid;
    }
}

