/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.admin;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaAuditCode;
import org.odpi.openmetadata.accessservices.subjectarea.listener.SubjectAreaOMRSTopicListener;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SubjectAreaAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private SubjectAreaServicesInstance instance = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", SubjectAreaAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            this.instance = new SubjectAreaServicesInstance(repositoryConnector, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                SubjectAreaOMRSTopicListener omrsTopicListener = new SubjectAreaOMRSTopicListener(accessServiceConfig.getAccessServiceOutTopic(), repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), accessServiceConfig.getAccessServiceName(), auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditLog.logMessage("initialize", SubjectAreaAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", SubjectAreaAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.SUBJECT_AREA_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", SubjectAreaAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

