/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.ProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProjectBuilder;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectHandler
extends SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaProjectHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);

    public SubjectAreaProjectHandler(OpenMetadataAPIGenericHandler genericHandler, int maxPageSize) {
        super(genericHandler, maxPageSize);
    }

    public SubjectAreaOMASAPIResponse<Project> createProject(String userId, Project suppliedProject) {
        String methodName = "createProject";
        SubjectAreaOMASAPIResponse<Project> response = new SubjectAreaOMASAPIResponse<Project>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
            String suppliedProjectName = suppliedProject.getName();
            if (suppliedProjectName == null || suppliedProjectName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_PROJECT_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createProject", "Name", null);
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedProject);
            Date effectiveFrom = null;
            Date effectiveTo = null;
            if (suppliedProject.getEffectiveFromTime() != null) {
                effectiveFrom = new Date(suppliedProject.getEffectiveFromTime());
            }
            if (suppliedProject.getEffectiveToTime() != null) {
                effectiveTo = new Date(suppliedProject.getEffectiveToTime());
            }
            ProjectBuilder builder = new ProjectBuilder(suppliedProject.getQualifiedName(), suppliedProject.getIdentifier(), suppliedProject.getName(), suppliedProject.getDescription(), suppliedProject.getStartDate(), suppliedProject.getPlannedEndDate(), suppliedProject.getStatus(), null, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", null, this.genericHandler.getRepositoryHelper(), this.genericHandler.getServiceName(), this.genericHandler.getServerName());
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            String entityDetailGuid = this.genericHandler.createBeanInRepository(userId, null, null, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", (OpenMetadataAPIGenericBuilder)builder, null, "createProject");
            if (entityDetailGuid != null) {
                response = this.getProjectByGuid(userId, entityDetailGuid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> getProjectByGuid(String userId, String guid) {
        String methodName = "getProjectByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            EntityDetail entityDetail = this.genericHandler.getEntityFromRepository(userId, guid, "guid", "Project", null, null, false, false, null, "getProjectByGuid");
            ProjectMapper projectMapper = this.mappersFactory.get(ProjectMapper.class);
            Project project = projectMapper.map(entityDetail);
            response.addResult((Object)project);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> findProject(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        String methodName = "findProject";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundProjects = this.findNodes(userId, "Project", "0799569f-0c16-4a1f-86d9-e2e89568f7fd", findRequest, exactValue, ignoreCase, ProjectMapper.class, "findProject");
            if (foundProjects == null) {
                return response;
            }
            response.addAllResults(foundProjects);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getProjectRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getProjectRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest, "Project");
    }

    public SubjectAreaOMASAPIResponse<Project> updateProject(String userId, String guid, Project suppliedProject, boolean isReplace) {
        String methodName = "updateProject";
        SubjectAreaOMASAPIResponse<Project> response = new SubjectAreaOMASAPIResponse<Project>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
            response = this.getProjectByGuid(userId, guid);
            if (response.head().isPresent()) {
                Project storedProject = (Project)response.head().get();
                ProjectMapper projectMapper = this.mappersFactory.get(ProjectMapper.class);
                EntityDetail suppliedEntity = projectMapper.map(suppliedProject);
                EntityDetail storedEntity = projectMapper.map(storedProject);
                this.genericHandler.updateBeanInRepository(userId, null, null, guid, "guid", "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", false, false, suppliedEntity.getProperties(), !isReplace, null, "updateProject");
                this.setNodeEffectivity(userId, (Node)suppliedProject, "updateProject", guid, "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project");
                response = this.getProjectByGuid(userId, guid);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> deleteProject(String userId, String guid) {
        String methodName = "deleteProject";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        boolean issueDelete = false;
        try {
            if (!this.genericHandler.isBeanIsolated(userId, guid, "Project", false, false, null, "deleteProject")) {
                throw new EntityNotDeletedException(SubjectAreaErrorCode.PROJECT_CONTENT_PREVENTED_DELETE.getMessageDefinition(new String[]{guid}), className, "deleteProject", guid);
            }
            issueDelete = true;
            if (issueDelete) {
                this.genericHandler.deleteBeanInRepository(userId, null, null, guid, "guid", "0799569f-0c16-4a1f-86d9-e2e89568f7fd", "Project", null, null, false, false, null, "deleteProject");
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> restoreProject(String userId, String guid) {
        String methodName = "restoreProject";
        SubjectAreaOMASAPIResponse<Project> response = new SubjectAreaOMASAPIResponse<Project>();
        try {
            this.genericHandler.getRepositoryHandler().restoreEntity(userId, null, null, guid, "restoreProject");
            response = this.getProjectByGuid(userId, guid);
        }
        catch (PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }
}

