/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ClassificationMapper;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidentialityMapper
extends ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(ConfidentialityMapper.class);
    private static final String className = ConfidentialityMapper.class.getName();
    private static final String typeName = "Confidentiality";

    public ConfidentialityMapper(OpenMetadataAPIGenericHandler genericHandler) {
        super(genericHandler);
    }

    @Override
    protected Set<String> mapKnownAttributesToOmrs(Classification omasClassification, InstanceProperties omrsClassificationProperties) {
        Confidentiality confidentiality = (Confidentiality)omasClassification;
        String stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "steward", omrsClassificationProperties, "");
        confidentiality.setSteward(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "notes", omrsClassificationProperties, "");
        confidentiality.setNotes(stringValue);
        int intValue = this.repositoryHelper.getIntProperty(this.genericHandler.getServiceName(), "confidence", omrsClassificationProperties, "");
        confidentiality.setConfidence(Integer.valueOf(intValue));
        intValue = this.repositoryHelper.getIntProperty(this.genericHandler.getServiceName(), "level", omrsClassificationProperties, "");
        confidentiality.setLevel(Integer.valueOf(intValue));
        Map instancePropertyMap = omrsClassificationProperties.getInstanceProperties();
        InstancePropertyValue instancePropertyValue = (InstancePropertyValue)instancePropertyMap.get("status");
        if (instancePropertyValue != null) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            GovernanceClassificationStatus status = GovernanceClassificationStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            confidentiality.setStatus(status);
        }
        return Confidentiality.getPropertyNames();
    }

    @Override
    protected String getTypeName() {
        return typeName;
    }

    @Override
    protected Classification createOmasClassification() {
        return new Confidentiality();
    }

    @Override
    protected InstanceProperties updateOMRSAttributes(Classification omasClassification) {
        InstanceProperties instanceProperties = new InstanceProperties();
        Confidentiality confidentiality = (Confidentiality)omasClassification;
        if (confidentiality.getSteward() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "steward", confidentiality.getSteward(), "updateOMRSAttributes");
        }
        if (confidentiality.getSource() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "source", confidentiality.getSource(), "updateOMRSAttributes");
        }
        if (confidentiality.getNotes() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "notes", confidentiality.getNotes(), "updateOMRSAttributes");
        }
        if (confidentiality.getConfidence() != null) {
            this.repositoryHelper.addIntPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "confidence", confidentiality.getConfidence().intValue(), "updateOMRSAttributes");
        }
        if (confidentiality.getLevel() != null) {
            this.repositoryHelper.addIntPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "level", confidentiality.getLevel().intValue(), "updateOMRSAttributes");
        }
        if (confidentiality.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(confidentiality.getStatus().getOrdinal());
            enumPropertyValue.setSymbolicName(confidentiality.getStatus().getName());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        return instanceProperties;
    }
}

