/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.RetentionBasis;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ClassificationMapper;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionMapper
extends ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(RetentionMapper.class);
    private static final String className = RetentionMapper.class.getName();
    private static final String typeName = "Retention";

    public RetentionMapper(OpenMetadataAPIGenericHandler genericHandler) {
        super(genericHandler);
    }

    @Override
    protected Set<String> mapKnownAttributesToOmrs(Classification omasClassification, InstanceProperties omrsClassificationProperties) {
        Retention retention = (Retention)omasClassification;
        String stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "steward", omrsClassificationProperties, "");
        retention.setSteward(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "source", omrsClassificationProperties, "");
        retention.setSteward(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "notes", omrsClassificationProperties, "");
        retention.setNotes(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.genericHandler.getServiceName(), "associatedGUID", omrsClassificationProperties, "");
        retention.setAssociatedGUID(stringValue);
        Date dateValue = this.repositoryHelper.getDateProperty(this.genericHandler.getServiceName(), "archiveAfter", omrsClassificationProperties, "");
        if (dateValue != null) {
            retention.setArchiveAfter(Long.valueOf(dateValue.getTime()));
        }
        if ((dateValue = this.repositoryHelper.getDateProperty(this.genericHandler.getServiceName(), "deleteAfter", omrsClassificationProperties, "")) != null) {
            retention.setDeleteAfter(Long.valueOf(dateValue.getTime()));
        }
        Integer intValue = this.repositoryHelper.getIntProperty(this.genericHandler.getServiceName(), "confidence", omrsClassificationProperties, "");
        retention.setConfidence(intValue);
        Map instancePropertyMap = omrsClassificationProperties.getInstanceProperties();
        if (instancePropertyMap != null) {
            EnumPropertyValue enumPropertyValue;
            InstancePropertyValue instancePropertyValue = (InstancePropertyValue)instancePropertyMap.get("status");
            if (instancePropertyValue != null) {
                enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                GovernanceClassificationStatus status = GovernanceClassificationStatus.valueOf((String)enumPropertyValue.getSymbolicName());
                retention.setStatus(status);
            }
            if ((instancePropertyValue = (InstancePropertyValue)instancePropertyMap.get("basis")) != null) {
                enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                RetentionBasis basis = RetentionBasis.valueOf((String)enumPropertyValue.getSymbolicName());
                retention.setBasis(basis);
            }
        }
        return Retention.getPropertyNames();
    }

    @Override
    protected String getTypeName() {
        return typeName;
    }

    @Override
    protected Classification createOmasClassification() {
        return new Retention();
    }

    @Override
    protected InstanceProperties updateOMRSAttributes(Classification omasClassification) {
        EnumPropertyValue enumPropertyValue;
        PrimitivePropertyValue primitivePropertyValue;
        InstanceProperties instanceProperties = new InstanceProperties();
        Retention retention = (Retention)omasClassification;
        if (retention.getSteward() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "steward", retention.getSteward(), "updateOMRSAttributes");
        }
        if (retention.getSource() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "source", retention.getSource(), "updateOMRSAttributes");
        }
        if (retention.getNotes() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "notes", retention.getNotes(), "updateOMRSAttributes");
        }
        if (retention.getAssociatedGUID() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.genericHandler.getServiceName(), instanceProperties, "associatedGUID", retention.getAssociatedGUID(), "updateOMRSAttributes");
        }
        if (retention.getArchiveAfter() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getArchiveAfter());
            instanceProperties.setProperty("archiveAfter", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getDeleteAfter() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getDeleteAfter());
            instanceProperties.setProperty("deleteAfter", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getConfidence() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
            primitivePropertyValue.setPrimitiveValue((Object)retention.getConfidence());
            instanceProperties.setProperty("confidence", (InstancePropertyValue)primitivePropertyValue);
        }
        if (retention.getBasis() != null) {
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(retention.getBasis().getOrdinal());
            enumPropertyValue.setSymbolicName(retention.getBasis().getName());
            instanceProperties.setProperty("basis", (InstancePropertyValue)enumPropertyValue);
        }
        if (retention.getStatus() != null) {
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(retention.getStatus().getOrdinal());
            enumPropertyValue.setSymbolicName(retention.getStatus().getName());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        return instanceProperties;
    }
}

