/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ObjectIdentifier;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceClassifications;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubjectAreaMapper
public class TermMapper
extends EntityDetailMapper<Term> {
    private static final Logger log = LoggerFactory.getLogger(TermMapper.class);
    private static final String className = TermMapper.class.getName();
    public static final String GLOSSARY_TERM = "GlossaryTerm";

    public TermMapper(OpenMetadataAPIGenericHandler genericHandler) {
        super(genericHandler);
    }

    @Override
    public Term map(EntityDetail entityDetail) {
        Term term = new Term();
        this.mapEntityDetailToNode(term, entityDetail);
        return term;
    }

    @Override
    public EntityDetail map(Term node) throws InvalidParameterException {
        return this.toEntityDetail(node);
    }

    @Override
    protected boolean mapPrimitiveToNode(Term term, String propertyName, Object value) {
        String stringValue = (String)value;
        boolean foundProperty = true;
        if (propertyName.equals("summary")) {
            term.setSummary(stringValue);
        } else if (propertyName.equals("abbreviation")) {
            term.setAbbreviation(stringValue);
        } else if (propertyName.equals("examples")) {
            term.setExamples(stringValue);
        } else if (propertyName.equals("usage")) {
            term.setUsage(stringValue);
        } else {
            foundProperty = false;
        }
        return foundProperty;
    }

    @Override
    protected void mapNodeToInstanceProperties(Term term, InstanceProperties instanceProperties) {
        if (term.getSummary() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getSummary(), "summary");
        }
        if (term.getAbbreviation() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getAbbreviation(), "abbreviation");
        }
        if (term.getExamples() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getExamples(), "examples");
        }
        if (term.getUsage() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getUsage(), "usage");
        }
        if (term.getName() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getName(), "displayName");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Term term, Classification omasClassification) {
        boolean handled = false;
        GovernanceClassifications governanceClassifications = term.getGovernanceClassifications();
        if (governanceClassifications == null) {
            governanceClassifications = new GovernanceClassifications();
        }
        String classificationName = omasClassification.getClassificationName();
        String sourceName = this.genericHandler.getServiceName();
        if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Confidentiality")) {
            governanceClassifications.setConfidentiality((Confidentiality)omasClassification);
            term.setGovernanceClassifications(governanceClassifications);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Confidence")) {
            governanceClassifications.setConfidence((Confidence)omasClassification);
            term.setGovernanceClassifications(governanceClassifications);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Criticality")) {
            governanceClassifications.setCriticality((Criticality)omasClassification);
            term.setGovernanceClassifications(governanceClassifications);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Retention")) {
            governanceClassifications.setRetention((Retention)omasClassification);
            term.setGovernanceClassifications(governanceClassifications);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "SpineObject")) {
            term.setSpineObject(true);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "SpineAttribute")) {
            term.setSpineAttribute(true);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "ObjectIdentifier")) {
            term.setObjectIdentifier(true);
            handled = true;
        }
        return handled;
    }

    @Override
    protected List<Classification> getInlinedClassifications(Term term) {
        ArrayList<Classification> inlinedClassifications = new ArrayList<Classification>();
        GovernanceClassifications governanceClassifications = term.getGovernanceClassifications();
        if (governanceClassifications != null) {
            Criticality criticality = governanceClassifications.getCriticality();
            Confidence confidence = governanceClassifications.getConfidence();
            Confidentiality confidentiality = governanceClassifications.getConfidentiality();
            Retention retention = governanceClassifications.getRetention();
            if (criticality != null) {
                inlinedClassifications.add((Classification)criticality);
            }
            if (confidence != null) {
                inlinedClassifications.add((Classification)confidence);
            }
            if (confidentiality != null) {
                inlinedClassifications.add((Classification)confidentiality);
            }
            if (retention != null) {
                inlinedClassifications.add((Classification)retention);
            }
        }
        if (term.isSpineObject()) {
            inlinedClassifications.add((Classification)new SpineObject());
        }
        if (term.isSpineAttribute()) {
            inlinedClassifications.add((Classification)new SpineAttribute());
        }
        if (term.isObjectIdentifier()) {
            inlinedClassifications.add((Classification)new ObjectIdentifier());
        }
        return inlinedClassifications;
    }

    @Override
    public String getTypeName() {
        return GLOSSARY_TERM;
    }
}

