/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMapper.class);
    private static final String className = ClassificationMapper.class.getName();
    protected final OpenMetadataAPIGenericHandler genericHandler;
    protected final OMRSRepositoryHelper repositoryHelper;

    protected ClassificationMapper(OpenMetadataAPIGenericHandler genericHandler) {
        this.genericHandler = genericHandler;
        this.repositoryHelper = genericHandler.getRepositoryHelper();
    }

    public org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification mapOmrsToBean(Classification omrsClassification) {
        String classificationTypeName = omrsClassification.getName();
        if (this.isTypeCorrect(classificationTypeName)) {
            org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = this.createOmasClassification();
            SystemAttributes systemAttributes = ClassificationMapper.createSystemAttributesFromOMRSClassification(omrsClassification);
            omasClassification.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            if (omrsClassificationProperties != null && omrsClassificationProperties.getInstanceProperties() != null && !omrsClassificationProperties.getInstanceProperties().isEmpty()) {
                omasClassification.setEffectiveFromTime(omrsClassificationProperties.getEffectiveFromTime());
                omasClassification.setEffectiveToTime(omrsClassificationProperties.getEffectiveToTime());
                Set<String> attributeNameSet = this.mapKnownAttributesToOmrs(omasClassification, omrsClassificationProperties);
                Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
                while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                    if (attributeNameSet.contains(name)) continue;
                    String attributeValue = null;
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            if (null == omasClassification.getAdditionalProperties()) {
                                omasClassification.setAdditionalProperties(Collections.emptyMap());
                            }
                            attributeValue = primitivePropertyValue.valueAsString();
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            if (null == omasClassification.getAdditionalProperties()) {
                                omasClassification.setAdditionalProperties(Collections.emptyMap());
                            }
                            attributeValue = enumPropertyValue.valueAsString();
                            break;
                        }
                        case MAP: {
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            if (null == omasClassification.getAdditionalProperties()) {
                                omasClassification.setAdditionalProperties(Collections.emptyMap());
                            }
                            attributeValue = mapPropertyValue.getMapValues().toString();
                            break;
                        }
                    }
                    omasClassification.getAdditionalProperties().put(name, attributeValue);
                }
            }
            return omasClassification;
        }
        return null;
    }

    public Classification mapBeanToOmrs(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        SystemAttributes systemAttributes = omasClassification.getSystemAttributes();
        Classification omrsClassification = new Classification();
        SubjectAreaUtils.populateSystemAttributesForInstanceAuditHeader(systemAttributes, (InstanceAuditHeader)omrsClassification);
        String classificationName = omasClassification.getClassificationName();
        omrsClassification.setName(classificationName);
        OpenMetadataTypesArchiveAccessor archiveAccessor = OpenMetadataTypesArchiveAccessor.getInstance();
        String classificationTypeGuid = archiveAccessor.getClassificationDefByName(classificationName).getGUID();
        InstanceType instanceType = new InstanceType();
        instanceType.setTypeDefName(classificationName);
        instanceType.setTypeDefGUID(classificationTypeGuid);
        omrsClassification.setType(instanceType);
        omrsClassification.setProperties(this.updateOMRSAttributes(omasClassification));
        return omrsClassification;
    }

    protected abstract org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification createOmasClassification();

    protected abstract Set<String> mapKnownAttributesToOmrs(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification var1, InstanceProperties var2);

    protected boolean isTypeCorrect(String actualTypeName) {
        return this.repositoryHelper.isTypeOf(this.genericHandler.getServiceName(), actualTypeName, this.getTypeName());
    }

    abstract String getTypeName();

    protected abstract InstanceProperties updateOMRSAttributes(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification var1);

    public static SystemAttributes createSystemAttributesFromOMRSClassification(Classification omrsClassification) {
        SystemAttributes systemAttributes = new SystemAttributes();
        Status status = SubjectAreaUtils.convertInstanceStatusToStatus(omrsClassification.getStatus());
        systemAttributes.setStatus(status);
        systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
        Date createtimeDate = omrsClassification.getCreateTime();
        Long createTimeLong = null;
        if (createtimeDate != null) {
            createTimeLong = createtimeDate.getTime();
        }
        systemAttributes.setCreateTime(createTimeLong);
        Date updatetimeDate = omrsClassification.getUpdateTime();
        Long updateTimeLong = null;
        if (updatetimeDate != null) {
            updateTimeLong = updatetimeDate.getTime();
        }
        systemAttributes.setUpdateTime(updateTimeLong);
        systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
        return systemAttributes;
    }
}

