/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/subject-area"})
public class SubjectAreaOMASGlossaryResource
extends SubjectAreaRESTServices {
    private SubjectAreaGlossaryRESTServices restAPI = new SubjectAreaGlossaryRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/glossaries"})
    public SubjectAreaOMASAPIResponse createGlossary(@PathVariable String userId, @RequestBody Glossary suppliedGlossary) {
        return this.restAPI.createGlossary(userId, suppliedGlossary);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/glossaries/{id}"})
    public SubjectAreaOMASAPIResponse getGlossary(@PathVariable String userId, @PathVariable String id, @RequestParam(value="idIsName", required=false) Boolean idIsName) {
        if (idIsName == null || !idIsName.booleanValue()) {
            return this.restAPI.getGlossaryByGuid(userId, id);
        }
        return this.restAPI.getGlossaryByName(userId, id);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse updateGlossary(@PathVariable String userId, @PathVariable String guid, Glossary glossary, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateGlossary(userId, guid, glossary, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse deleteGlossary(@PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteGlossary(userId, guid, isPurge);
    }
}

