/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaCategoryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/subject-area"})
public class SubjectAreaCategoryRESTResource
extends SubjectAreaRESTServices {
    private SubjectAreaCategoryRESTServices restAPI = new SubjectAreaCategoryRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userid}/categories"})
    public SubjectAreaOMASAPIResponse createGlossary(@PathVariable String userid, @RequestBody Category suppliedCategory) {
        return this.restAPI.createCategory(userid, suppliedCategory);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userid}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse getCategoryByGuid(@PathVariable String userid, @PathVariable String guid) {
        return this.restAPI.getCategory(userid, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userid}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse updateCategory(@PathVariable String userid, @PathVariable String guid, Category suppliedCategory, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateCategory(userid, guid, suppliedCategory, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userid}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse deleteCategory(@PathVariable String userid, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteCategory(userid, guid, isPurge);
    }
}

