/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/subject-area"})
public class SubjectAreaGlossaryRESTResource
extends SubjectAreaRESTServices {
    private SubjectAreaGlossaryRESTServices restAPI = new SubjectAreaGlossaryRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userid}/glossaries"})
    public SubjectAreaOMASAPIResponse createGlossary(@PathVariable String userid, @RequestBody Glossary suppliedGlossary) {
        return this.restAPI.createGlossary(userid, suppliedGlossary);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userid}/glossaries/{id}"})
    public SubjectAreaOMASAPIResponse getGlossary(@PathVariable String userid, @PathVariable String id, @RequestParam(value="idIsName", required=false) Boolean idIsName) {
        if (idIsName == null || !idIsName.booleanValue()) {
            return this.restAPI.getGlossaryByGuid(userid, id);
        }
        return this.restAPI.getGlossaryByName(userid, id);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userid}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse updateGlossary(@PathVariable String userid, @PathVariable String guid, Glossary glossary, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateGlossary(userid, guid, glossary, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userid}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse deleteGlossary(@PathVariable String userid, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteGlossary(userid, guid, isPurge);
    }
}

