/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaTermRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/subject-area"})
public class SubjectAreaTermRESTResource
extends SubjectAreaRESTServices {
    private SubjectAreaTermRESTServices restAPI = new SubjectAreaTermRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/terms"})
    public SubjectAreaOMASAPIResponse createTerm(@PathVariable String userId, @RequestBody Term suppliedTerm) {
        return this.restAPI.createTerm(userId, suppliedTerm);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse getTermByGuid(@PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermByGuid(userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse updateTerm(@PathVariable String userId, @PathVariable String guid, Term suppliedTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTerm(userId, guid, suppliedTerm, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTerm(@PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTerm(userId, guid, isPurge);
    }
}

