/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
public class SubjectAreaGlossaryRESTResource
extends SubjectAreaRESTServicesInstance {
    private SubjectAreaGlossaryRESTServices restAPI = new SubjectAreaGlossaryRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/glossaries"})
    public SubjectAreaOMASAPIResponse createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestBody Glossary suppliedGlossary) {
        return this.restAPI.createGlossary(serverName, userId, suppliedGlossary);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse getGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGlossaryByGuid(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/glossaries"})
    public SubjectAreaOMASAPIResponse findGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findGlossary(serverName, userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/glossaries/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getGlossaryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getGlossaryRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Glossary glossary, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateGlossary(serverName, userId, guid, glossary, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse deleteGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteGlossary(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse restoreGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreGlossary(serverName, userId, guid);
    }
}

